package mobvista.dmp.datasource.taobao


import mobvista.dmp.common.CommonSparkJob
import mobvista.dmp.util.PropertyUtil
import mobvista.dmp.utils.clickhouse.ClickHouseConnectionFactory
import mobvista.dmp.utils.clickhouse.ClickHouseSparkExt._
import org.apache.commons.cli.Options
import org.apache.spark.sql.types.{StringType, StructField, StructType}
import org.apache.spark.sql.{Row, SparkSession}
import ru.yandex.clickhouse.ClickHouseDataSource

class YOUKUImeiLaXinCK extends CommonSparkJob with Serializable {
  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("imeiInput", true, "imeiInput")
    options.addOption("date", true, "date")
    options.addOption("host", true, "host")
    options.addOption("cluster", true, "cluster")
    options.addOption("database", true, "database")
    options.addOption("table", true, "table")
    options
  }

  val schema = StructType(Array(
    StructField("device_ids", StringType)))

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)


    val imeiInput = commandLine.getOptionValue("imeiInput")
    val date = commandLine.getOptionValue("date")
    val cluster = commandLine.getOptionValue("cluster")
    val host = commandLine.getOptionValue("host")
    val database = commandLine.getOptionValue("database")
    val table = commandLine.getOptionValue("table")

    val spark = SparkSession
      .builder()
      .appName(s"YOUKUImeiLaXinCK.$date")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "lz4")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .config("spark.clickhouse.driver", "ru.yandex.clickhouse.ClickHouseDriver")
      .config("spark.clickhouse.url", PropertyUtil.getProperty("config.properties", "spark.clickhouse.url"))
      .config("spark.clickhouse.connection.per.executor.max", "5")
      .config("spark.clickhouse.metrics.enable", "true")
      .config("spark.clickhouse.socket.timeout.ms", "300000")
      .config("spark.clickhouse.cluster.auto-discovery", "true")
      .enableHiveSupport()
      .getOrCreate()
    val sc = spark.sparkContext


    try {

      try {
        //存储imeimd5数据到clickhouse
        val imeiRDD = sc.textFile(imeiInput).map(r => {
          Row(r)
        })

        implicit val clickhouseDataSource: ClickHouseDataSource = ClickHouseConnectionFactory.get(host)

        val clusterName = Some(cluster): Option[String]

        //存储imei到clickhouse
        val device_type="IMEI_MD5"
        val imeiDF = spark.emptyDataFrame
        //  drop table
        imeiDF.dropPartition(database, table, s"($date,'$device_type')", clusterName)
        val dt = mobvista.dmp.common.MobvistaConstant.sdf1.format(mobvista.dmp.common.MobvistaConstant.sdf2.parse(date))
        spark.createDataFrame(imeiRDD, schema).saveToClickHouse(database, table, Seq(dt,device_type), Seq("dt","device_type"), clusterName, batchSize = 1000000)

      } finally {
        sc.stop()
        spark.stop()
      }
      0

    }
  }
}


object YOUKUImeiLaXinCK {
  def main(args: Array[String]): Unit = {
    new YOUKUImeiLaXinCK().run(args)
  }
}
