/*
 * Decompiled with CFR 0.152.
 */
package io.clickhouse.spark.connection;

import io.clickhouse.spark.connection.ClickHouseDataSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;

public final class ClickHouseDataSource$
implements Serializable {
    public static ClickHouseDataSource$ MODULE$;
    private final String JDBC_PREFIX;
    private final String JDBC_CLICKHOUSE_PREFIX;
    private final Pattern URL_TEMPLATE;

    static {
        new ClickHouseDataSource$();
    }

    private String JDBC_PREFIX() {
        return this.JDBC_PREFIX;
    }

    private String JDBC_CLICKHOUSE_PREFIX() {
        return this.JDBC_CLICKHOUSE_PREFIX;
    }

    private Pattern URL_TEMPLATE() {
        return this.URL_TEMPLATE;
    }

    public ClickHouseDataSource apply(String url) {
        return this.splitUrl(url);
    }

    private ClickHouseDataSource splitUrl(String url) {
        Matcher m = this.URL_TEMPLATE().matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException("Incorrect url");
        }
        ObjectRef database = ObjectRef.create((Object)m.group(2));
        if ((String)database.elem == null) {
            database.elem = "";
        }
        String[] hosts = m.group(1).split(",");
        Map value = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hosts)).map((Function1 & java.io.Serializable & Serializable)hostWithPort -> new Tuple2((Object)hostWithPort.split(":")[0], (Object)new StringBuilder(2).append(MODULE$.JDBC_CLICKHOUSE_PREFIX()).append("//").append((String)hostWithPort).append((String)database$1.elem).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new ClickHouseDataSource((Map<String, String>)value, (String)database.elem);
    }

    public ClickHouseDataSource apply(Iterable<String> hosts, int port, String database) {
        Map value = ((TraversableOnce)hosts.map((Function1 & java.io.Serializable & Serializable)host -> new Tuple2(host, (Object)new StringBuilder(0).append(MODULE$.JDBC_CLICKHOUSE_PREFIX()).append(new StringBuilder(3).append("//").append((String)host).append(":").append(port).toString()).append(database).toString()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new ClickHouseDataSource((Map<String, String>)value, database);
    }

    public ClickHouseDataSource apply(Map<String, String> value, String database) {
        return new ClickHouseDataSource(value, database);
    }

    public Option<Tuple2<Map<String, String>, String>> unapply(ClickHouseDataSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.value(), (Object)x$0.database()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ClickHouseDataSource$() {
        MODULE$ = this;
        this.JDBC_PREFIX = "jdbc:";
        this.JDBC_CLICKHOUSE_PREFIX = new StringBuilder(11).append(this.JDBC_PREFIX()).append("clickhouse:").toString();
        this.URL_TEMPLATE = Pattern.compile(new StringBuilder(38).append(this.JDBC_CLICKHOUSE_PREFIX()).append("//([a-zA-Z0-9_:,.-]+)(/[a-zA-Z0-9_]+)?").toString());
    }
}

