/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.api.request;

import com.dingtalk.api.response.OapiDingtaxUserPushResponse;
import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OapiDingtaxUserPushRequest
extends BaseTaobaoRequest<OapiDingtaxUserPushResponse> {
    private String sourceRegion;
    private String userInfoList;
    private String topResponseType = "dingtalk";
    private String topHttpMethod = "POST";

    public void setSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
    }

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    public void setUserInfoList(String userInfoList) {
        this.userInfoList = userInfoList;
    }

    public void setUserInfoList(List<DingTaxUserInfoDTO> userInfoList) {
        this.userInfoList = new JSONWriter(false, false, true).write(userInfoList);
    }

    public String getUserInfoList() {
        return this.userInfoList;
    }

    @Override
    public String getApiMethodName() {
        return "dingtalk.oapi.dingtax.user.push";
    }

    @Override
    public String getTopResponseType() {
        return this.topResponseType;
    }

    @Override
    public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
    }

    @Override
    public String getTopApiCallType() {
        return "oapi";
    }

    @Override
    public String getTopHttpMethod() {
        return this.topHttpMethod;
    }

    @Override
    public void setTopHttpMethod(String topHttpMethod) {
        this.topHttpMethod = topHttpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.setTopHttpMethod(httpMethod);
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("source_region", this.sourceRegion);
        txtParams.put("user_info_list", this.userInfoList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<OapiDingtaxUserPushResponse> getResponseClass() {
        return OapiDingtaxUserPushResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.sourceRegion, "sourceRegion");
        RequestCheckUtils.checkObjectMaxListSize(this.userInfoList, 20, "userInfoList");
    }

    public static class DingTaxUserInfoDTO
    extends TaobaoObject {
        private static final long serialVersionUID = 8369832627373231663L;
        @ApiField(value="new_user")
        private String newUser;
        @ApiField(value="taxation_type")
        private String taxationType;
        @ApiField(value="user_mobile")
        private String userMobile;
        @ApiField(value="user_role")
        private String userRole;

        public String getNewUser() {
            return this.newUser;
        }

        public void setNewUser(String newUser) {
            this.newUser = newUser;
        }

        public String getTaxationType() {
            return this.taxationType;
        }

        public void setTaxationType(String taxationType) {
            this.taxationType = taxationType;
        }

        public String getUserMobile() {
            return this.userMobile;
        }

        public void setUserMobile(String userMobile) {
            this.userMobile = userMobile;
        }

        public String getUserRole() {
            return this.userRole;
        }

        public void setUserRole(String userRole) {
            this.userRole = userRole;
        }
    }
}

