#!/bin/bash


source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")

business="allpb"

INPUT_PATH="${DM_INSTALL_LIST}/$date_path/${business}"
OUTPUT_PATH="${DM_INSTALL_LIST}_v2/$date_path/${business}"

check_await ${INPUT_PATH}/_SUCCESS

hadoop fs -rm -r ${OUTPUT_PATH}

REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH})

hadoop jar ../${JAR} mobvista.dmp.main.ParseInstallRCFile \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  ${INPUT_PATH} ${OUTPUT_PATH} ${REDUCE_NUM}

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_install_list_v2" "dt='$LOG_TIME', business='${business}'" "$OUTPUT_PATH"
if [ $? -ne 0 ];then
  exit 255
fi
