#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file  : ad_server_package.sh
# @author: rongpei
# @date  : 17-04-27
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}
date_path="${year}/${month}/${day}"
old_path=$(date -d"$LOG_TIME -1 day " +"%Y/%m/%d")

INPUT_SERVER_EMPTY_ADN="s3://mob-ad/adn/adn_net/notice/ad_server_empty/$date_path/*/*"
INPUT_SERVER_ADN="s3://mob-ad/adn/adn_net/notice/ad_server/$date_path/*/*"
INPUT_CAMPAIGN="${DIM_ADN_CAMPAIGN}/$date_path"
TMP_CAMPAIGN_TAG_OUTPUT="${TMP_ADSERVER_PKG_TMP_PATH}/$date_path"
CAMPAIGN_TAG_OUTPUT="${TMP_ADSERVER_PACKAGE_PATH}/$date_path"

exit 0

check_await "s3://mob-ad/adn/adn_net/notice/ad_server_empty/$date_path/virginia/23"
check_await "s3://mob-ad/adn/adn_net/notice/ad_server/$date_path/virginia/23"

hadoop fs -rm "$TMP_CAMPAIGN_TAG_OUTPUT/*"

hadoop jar ../${JAR} mobvista.dmp.datasource.packagelist.mapreduce.AdServerPackage \
    "$INPUT_SERVER_EMPTY_ADN" "$INPUT_SERVER_ADN" "$INPUT_CAMPAIGN" "$TMP_CAMPAIGN_TAG_OUTPUT"  || exit 1

# 为bundleId 匹配 packageName
matchBundlePackage "$date_path" "$old_path" "2" "3" "$TMP_CAMPAIGN_TAG_OUTPUT" "$CAMPAIGN_TAG_OUTPUT" "adserver" "../${JAR}"
if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "etl_adserver_install_daily" "\`date\`='$LOG_TIME'" "$CAMPAIGN_TAG_OUTPUT" || exit 1
remove_dir $TMP_CAMPAIGN_TAG_OUTPUT

echo "[ad_server_package End!]"


