#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :calc_package_dict_age.sh
# @author  :wangjf
# @revision:2018-09-26 10:47:07
# @description: 重构
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}


INPUT_PATH="${AGE_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${AGE_CALC_PACKAGE_DICT}/${year}/${month}/${day}/"
LOW="100"
HIGH="35000"
UNBELIEVABLE="0.95"

spark-submit --class mobvista.dmp.datasource.age_gender.CalcPackageAge \
     --name "CalcPackageAge.${LOG_TIME}" \
     --conf spark.default.parallelism=1000 \
     --conf spark.storage.memoryFraction=0.4 \
     --conf spark.shuffle.memoryFraction=0.4 \
     --conf spark.sql.files.maxPartitionBytes=134217728 \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 100 \
     ../${JAR} -inputPath ${INPUT_PATH} -outputPath ${OUTPUT_PATH} -parallelism 1 -low ${LOW} -high ${HIGH} -unbelievable ${UNBELIEVABLE}

if [[ $? -ne 0 ]];then
  exit 255
fi