#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2019-08-28 18:06:59
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y-%m-%d")

BEFORE_LOG_TIME=$(date -d "$ScheduleTime" +"%Y-%m-%d")

date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")
DAILY_INPUT="${IQiYi_DAILY_PATH}/${date_path}"
check_await "${DAILY_INPUT}/_SUCCESS"

check_process() {
    shell=$1
    pid=$(ps aux h | grep "${shell}" |grep -v 'grep' |awk '{print $2}' | sort -n | head -n 1)
    if [[ ${pid} != '' && ${pid} -gt 0 ]];then
        sleep 60 && kill ${pid} && echo "${pid}.command is complete"
    else
        echo "${pid}.command is complete"
    fi
}

if [[ ! -d "/home/hadoop/wangjf" ]]; then
  mkdir /home/hadoop/wangjf

  cd /home/hadoop/wangjf/

  hdfs dfs -get s3://mob-emr-test/wangjf/data/pem/dataplatform_cn.pem .

  chmod 600 dataplatform_cn.pem
fi

appId=2
appOs=3
fors=400
concurrent=10000

shell=" -cp /root/workspace/DMP-1.0.3-jar-with-dependencies.jar mobvista.dmp.datasource.baichuan.BaiChuanMainV2 ${appId} ${appOs} ${fors} ${concurrent} ${BEFORE_LOG_TIME}"

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]];then
  exit 255
fi

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "/root/workspace/exec_ali.sh ${appId} ${appOs} ${fors} ${concurrent} ${LOG_TIME} >/root/workspace/exec_ali_2_3.log"

if [[ $? -ne 0 ]];then
  exit 255
fi

# sleep $[fors * 30]

check_process "/root/workspace/exec_ali.sh ${appId} ${appOs} ${fors} ${concurrent} ${LOG_TIME}"

if [[ $? -ne 0 ]];then
    exit 255
fi

shell=" -cp /root/workspace/DMP-1.0.3-jar-with-dependencies.jar mobvista.dmp.datasource.baichuan.BaiChuanMainV2 ${appId} ${appOs} ${fors} ${concurrent} ${LOG_TIME}"

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]];then
    exit 255
else
    exit 0
fi