#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH_TMP="${GDT_DATA}/day=${dt_today}/category=append/"
ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH_TMP="${GDT_DATA}/day=${dt_today}/category=delete/"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH_TMP}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH_TMP}"

ALI_USER_ACTIVATION_SYS_TO3S_PATH="$ALI_USER_ACTIVATION_SYS_TO3S/${dt_slash_today}"
mount_partition "gdt_data" "day='${dt_today}', category='all', business='total'" "${ALI_USER_ACTIVATION_SYS_TO3S_PATH}"



HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}  -hivevar  dt_oneday_ago ${dt_oneday_ago}  -f ali_extract_guangdiantong_data.sql

if [ $? -ne 0 ];then
  exit 255
fi

rm -rf guangdiantong
mkdir guangdiantong
cd guangdiantong

ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}"
#推广点通数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}
fi

dirs=$(hadoop fs -ls ${ALI_USER_ACTIVATION_SYS_TO3S_PATH} | awk -F'/' '{print $12}' | grep  -E "imei|idfa|oaid")
for path in $dirs;do
  tmp_result_path=${path#*_}
  echo $tmp_result_path

  if [[ $tmp_result_path =~ "idfa" ]]
  then
      result_path=${tmp_result_path%_*}_HASH_IDFA
      echo $result_path
  elif [[ $tmp_result_path =~ "imei" ]]; then
      result_path=${tmp_result_path%_*}_HASH_IMEI
      echo $result_path
  elif [[ $tmp_result_path =~ "oaid" ]]; then
      result_path=${tmp_result_path%_*}_HASH_OAID
      echo $result_path
  else
      echo "error"
      exit 1
  fi

  hadoop fs -text  ${ALI_USER_ACTIVATION_SYS_TO3S_PATH}/${path}/* > ${result_path}.csv
  split -b 160m  ${result_path}.csv  -d -a 2 ${result_path}_

  for new_path in $(ls ${result_path}_*)
    do
     zip ${new_path}.zip ${new_path}
     hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}/"
     rm -f ${new_path}*
  done
  rm -f ${result_path}.csv
done


ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_PATH}/${dt_slash_today}"
ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}"



#推广点通追加数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}
fi

dirs=$(hadoop fs -ls ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH_TMP} | awk -F'/' '{print $11}' | grep  -E "imei|idfa|oaid")
for path in $dirs;do
  tmp_result_path=${path#*=}
  echo $tmp_result_path

  if [[ $tmp_result_path =~ "idfa" ]]
  then
      result_path=${tmp_result_path%_*}_HASH_IDFA
      echo $result_path
  elif [[ $tmp_result_path =~ "imei" ]]; then
      result_path=${tmp_result_path%_*}_HASH_IMEI
      echo $result_path
  elif [[ $tmp_result_path =~ "oaid" ]]; then
      result_path=${tmp_result_path%_*}_HASH_OAID
      echo $result_path
  else
      echo "error"
      exit 1
  fi

  hadoop fs -text  ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH_TMP}/${path}/* > ${result_path}.csv
  split -b 160m  ${result_path}.csv  -d -a 2 ${result_path}_

  for new_path in $(ls ${result_path}_*)
    do
     zip ${new_path}.zip ${new_path}
     hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}/"
     rm -f ${new_path}*
  done
  rm -f ${result_path}.csv
done



#推广点通删除数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}
fi

dirs=$(hadoop fs -ls ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH_TMP} | awk -F'/' '{print $11}' | grep  -E "imei|idfa|oaid")
for path in $dirs;do
  tmp_result_path=${path#*=}
  echo $tmp_result_path

  if [[ $tmp_result_path =~ "idfa" ]]
  then
      result_path=${tmp_result_path%_*}_HASH_IDFA
      echo $result_path
  elif [[ $tmp_result_path =~ "imei" ]]; then
      result_path=${tmp_result_path%_*}_HASH_IMEI
      echo $result_path
   elif [[ $tmp_result_path =~ "oaid" ]]; then
      result_path=${tmp_result_path%_*}_HASH_OAID
      echo $result_path
  else
      echo "error"
      exit 1
  fi

  hadoop fs -text  ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH_TMP}/${path}/* > ${result_path}.csv
  split -b 160m  ${result_path}.csv  -d -a 2 ${result_path}_

  for new_path in $(ls ${result_path}_*)
    do
     zip ${new_path}.zip ${new_path}
     hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}/"
     rm -f ${new_path}*
  done
  rm -f ${result_path}.csv
done



rm -rf guangdiantong
echo "good job~~"


