#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

ALI_USER_ACTIVATION_SYS_TO3S_PATH="$ALI_USER_ACTIVATION_SYS_TO3S/${dt_slash_today}"
mount_partition "gdt_data" "day='${dt_today}', category='all', business='total'" "${ALI_USER_ACTIVATION_SYS_TO3S_PATH}"

#H_19_IMEI
OUTPUT_PATH01="${TMP_DEVICEID}/${dt_slash_today}/other_data/227229_imei"
#H_19_HASH_IMEI
OUTPUT_PATH02="${TMP_DEVICEID}/${dt_slash_today}/other_data/227229_imeimd5"


#H_19_IMEI append
IMEI_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=227229_oppo_package/business=imei_append"
mount_partition "gdt_data" "day='${dt_today}', category='227229_oppo_package', business='imei_append'" "${IMEI_GUANGDIANTONG_RES_APPEND_PATH}"
#H_19_HASH_IMEI append
IMEIMD5_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=227229_oppo_package/business=imeimd5_append"
mount_partition "gdt_data" "day='${dt_today}', category='227229_oppo_package', business='imeimd5_append'" "${IMEIMD5_GUANGDIANTONG_RES_APPEND_PATH}"

#H_19_IMEI delete
IMEI_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=227229_oppo_package/business=imei_delete"
mount_partition "gdt_data" "day='${dt_today}', category='227229_oppo_package', business='imei_delete'" "${IMEI_GUANGDIANTONG_RES_DELETE_PATH}"
#H_19_HASH_IMEI delete
IMEIMD5_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=227229_oppo_package/business=imeimd5_delete"
mount_partition "gdt_data" "day='${dt_today}', category='227229_oppo_package', business='imeimd5_delete'" "${IMEIMD5_GUANGDIANTONG_RES_DELETE_PATH}"

HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}   -f ali_extract_guangdiantong_data_h_19.sql

if [ $? -ne 0 ];then
  exit 255
fi

rm -rf guangdiantong_H_19
mkdir guangdiantong_H_19
cd guangdiantong_H_19

ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_PATH}/${dt_slash_today}"
#推广点通数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}
fi


#增加com.taobao.foractivation.227229_oppo伪包名，为H_19   H_19_IMEI
hadoop fs -text  ${OUTPUT_PATH01}/* > H_19_IMEI.csv
split -b 160m  H_19_IMEI.csv  -d -a 2 H_19_IMEI_

for new_path in $(ls H_19_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_19_IMEI.csv
#H_19_HASH_IMEI
hadoop fs -text  ${OUTPUT_PATH02}/* > H_19_HASH_IMEI.csv
split -b 160m  H_19_HASH_IMEI.csv  -d -a 2 H_19_HASH_IMEI_

for new_path in $(ls H_19_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_19_HASH_IMEI.csv


#hadoop fs -touchz ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}/_SUCCESS

ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_PATH}/${dt_slash_today}"
ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_PATH}/${dt_slash_today}"
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}
fi

hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}
fi

#增加com.taobao.foractivation.227229_oppo伪包名，为H_19   H_19_IMEI append
hadoop fs -text  ${IMEI_GUANGDIANTONG_RES_APPEND_PATH}/* > H_19_IMEI.csv
split -b 160m  H_19_IMEI.csv  -d -a 2 H_19_IMEI_

for new_path in $(ls H_19_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_19_IMEI.csv
#H_19_HASH_IMEI   append
hadoop fs -text  ${IMEIMD5_GUANGDIANTONG_RES_APPEND_PATH}/* > H_19_HASH_IMEI.csv
split -b 160m  H_19_HASH_IMEI.csv  -d -a 2 H_19_HASH_IMEI_

for new_path in $(ls H_19_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_19_HASH_IMEI.csv

#hadoop fs -touchz ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}/_SUCCESS


#推广点通删除数据
#增加com.taobao.foractivation.227229_oppo伪包名，为H_19    H_19_IMEI delete
hadoop fs -text  ${IMEI_GUANGDIANTONG_RES_DELETE_PATH}/* > H_19_IMEI.csv
split -b 160m  H_19_IMEI.csv  -d -a 2 H_19_IMEI_

for new_path in $(ls H_19_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_19_IMEI.csv
#H_19_HASH_IMEI   delete
hadoop fs -text  ${IMEIMD5_GUANGDIANTONG_RES_DELETE_PATH}/* > H_19_HASH_IMEI.csv
split -b 160m  H_19_HASH_IMEI.csv  -d -a 2 H_19_HASH_IMEI_

for new_path in $(ls H_19_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_19_HASH_IMEI.csv


#hadoop fs -touchz ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}/_SUCCESS

rm -rf guangdiantong_H_19
echo "good job~~"


