#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")

dt_slash_oneday=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
expire_date=$(date -d "$ScheduleTime 61 days ago" +"%Y%m%d")
expire_date_path=$(date -d "$ScheduleTime 61 days ago" +"%Y/%m/%d")
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_oneday}/dsp_req/_SUCCESS"

EXPIRE_OUTPUT_PATH05="${TMP_DEVICEID}/${expire_date_path}/other_data/204543_imei"
EXPIRE_OUTPUT_PATH06="${TMP_DEVICEID}/${expire_date_path}/other_data/204543_imeimd5"
EXPIRE_OUTPUT_PATH07="${TMP_DEVICEID}/${expire_date_path}/other_data/227229_imei"
EXPIRE_OUTPUT_PATH08="${TMP_DEVICEID}/${expire_date_path}/other_data/227229_imeimd5"
EXPIRE_OUTPUT_PATH09="${TMP_DEVICEID}/${expire_date_path}/other_data/188844_imei"
EXPIRE_OUTPUT_PATH10="${TMP_DEVICEID}/${expire_date_path}/other_data/188844_imeimd5"
EXPIRE_OUTPUT_PATH11="${TMP_DEVICEID}/${expire_date_path}/other_data/iqyi_227229_imeimd5"
EXPIRE_OUTPUT_PATH12="${TMP_DEVICEID}/${expire_date_path}/other_data/iqyi_227229_oaidmd5"

OUTPUT_PATH="${TMP_DEVICEID}/${dt_slash_today}/other_data/"

OUTPUT_PATH05="${TMP_DEVICEID}/${dt_slash_today}/other_data/204543_imei"
OUTPUT_PATH06="${TMP_DEVICEID}/${dt_slash_today}/other_data/204543_imeimd5"
OUTPUT_PATH07="${TMP_DEVICEID}/${dt_slash_today}/other_data/227229_imei"
OUTPUT_PATH08="${TMP_DEVICEID}/${dt_slash_today}/other_data/227229_imeimd5"
OUTPUT_PATH09="${TMP_DEVICEID}/${dt_slash_today}/other_data/188844_imei"
OUTPUT_PATH10="${TMP_DEVICEID}/${dt_slash_today}/other_data/188844_imeimd5"
OUTPUT_PATH11="${TMP_DEVICEID}/${dt_slash_today}/other_data/iqyi_227229_imeimd5"
OUTPUT_PATH12="${TMP_DEVICEID}/${dt_slash_today}/other_data/iqyi_227229_oaidmd5"


hadoop fs -rm -r "${OUTPUT_PATH}"


spark-submit --class mobvista.dmp.datasource.taobao.EtlOtherDataFromPostBackDaily \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --files ${HIVE_SITE_PATH} \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 6  --num-executors 150 \
 ../../${JAR}  \
 -output ${OUTPUT_PATH} \
 -dt_today ${dt_today} -dt_oneday_ago ${dt_oneday_ago}


if [ $? -ne 0 ];then
  exit 255
fi


mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='204543_imei'" "${OUTPUT_PATH05}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='204543_imeimd5'" "${OUTPUT_PATH06}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='227229_imei'" "${OUTPUT_PATH07}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='227229_imeimd5'" "${OUTPUT_PATH08}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='188844_imei'" "${OUTPUT_PATH09}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='188844_imeimd5'" "${OUTPUT_PATH10}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='iqyi_227229_imeimd5'" "${OUTPUT_PATH11}"
mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='iqyi_227229_oaidmd5'" "${OUTPUT_PATH12}"

if [ $? -ne 0 ];then
  exit 255
fi

unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='204543_imei'" "${EXPIRE_OUTPUT_PATH05}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='204543_imeimd5'" "${EXPIRE_OUTPUT_PATH06}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='227229_imei'" "${EXPIRE_OUTPUT_PATH07}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='227229_imeimd5'" "${EXPIRE_OUTPUT_PATH08}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='188844_imei'" "${EXPIRE_OUTPUT_PATH09}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='188844_imeimd5'" "${EXPIRE_OUTPUT_PATH10}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='iqyi_227229_imeimd5'" "${EXPIRE_OUTPUT_PATH11}"
unmount_partition "dm_install_list_v2_tmp_deviceid" "dt='${expire_date}', device_type='iqyi_227229_oaidmd5'" "${EXPIRE_OUTPUT_PATH12}"

echo "good job~~"
