#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :wangjf
# @revision:2019-09-03 11:13:18
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
# before_date_path=$(date +%Y/%m/%d -d "-2 day $today")

# TRACKING_INSTALL_DAILY="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_tracking_install_daily/${date_path}"
# TRACKING_EVENT_DAILY="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_3s_event_daily/${date_path}"

# check_await ${TRACKING_INSTALL_DAILY}/_SUCCESS
# check_await ${TRACKING_EVENT_DAILY}/_SUCCESS

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="sss_tracking_daily"

spark-submit --class mobvista.dmp.clickhouse.tracking.TrackingDaily \
     --name "mobvista.dmp.clickhouse.tracking.TrackingDaily_wangjf_${date}" \
     --conf spark.sql.shuffle.partitions=2000 \
     --conf spark.default.parallelism=2000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 10 \
     ../../${JAR} -date ${date} -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]]; then
    exit 255
fi