#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    : dm_interest_tag_daily.sh
# @author  : fengliang
# @time    : 2018-04-08
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=${ScheduleTime:-$1}
date=$(date +%Y%m%d -d "-1 day $LOG_TIME")
old_date=$(date +%Y%m%d -d "-2 day $LOG_TIME")
date_path=$(date +"%Y/%m/%d" -d "-1 day ${LOG_TIME}")
last_req_date=$(date +"%Y-%m-%d" -d "-1 day ${LOG_TIME}")

SSS_USER_INFO_PATH="${ODS_DMP_USER_INFO}/$date_path/3s"
ADN_USER_INFO_PATH="${ODS_DMP_USER_INFO}/$date_path/adn_request"
DSP_USER_INFO_PATH="${ODS_DMP_USER_INFO}/$date_path/dsp_req"
ALL_INTEREST_TAG_PATH="${DM_DEV_INTEREST_PATH}_orc/$date_path/all"
OUTPUT_PATH="${DM_INTEREST_DAILY_PATH}/${date_path}"

check_await $SSS_USER_INFO_PATH/_SUCCESS
check_await $ADN_USER_INFO_PATH/_SUCCESS
check_await $DSP_USER_INFO_PATH/_SUCCESS
check_await $ALL_INTEREST_TAG_PATH/_SUCCESS

ga_date=`get_recently_date "${ODS_DMP_USER_INFO}" "${old_date}" "ga"`
ga_last_req_date=$(date -d"$ga_date" +"%Y-%m-%d")

sql="
  use dwh;
  set hive.auto.convert.join=true;
  set mapreduce.map.speculative=true;
  set hive.exec.compress.output=true;
  set mapreduce.reduce.speculative=true;
  set mapreduce.output.fileoutputformat.compress.type=BLOCK;
  set mapreduce.job.reduce.slowstart.completedmaps=1.0;
  set mapreduce.job.speculative.slowtaskthreshold=1.0;
  set mapreduce.output.fileoutputformat.compress.codec=org.apache.hadoop.io.compress.GzipCodec;
  set mapreduce.map.memory.mb=4096;
  set mapreduce.map.java.opts=-Xmx2458m;
  set mapreduce.reduce.memory.mb=4096;
  set mapreduce.reduce.java.opts=-Xmx2458m;

  create external table IF NOT EXISTS tmp_interest_tag_daily_${date} (
    device_id string,
    device_type string,
    platform string,
    tags string
  )
  ROW FORMAT DELIMITED FIELDS TERMINATED BY '\t'
  location '${OUTPUT_PATH}';

  insert overwrite table tmp_interest_tag_daily_${date}
  select a.device_id, a.device_type, b.platform, b.tags
  from (
    select t.device_id, t.device_type
    from (
      select t.device_id, t.device_type
      from dwh.ods_dmp_user_info t
      where t.dt='${date}' and t.business <> 'ga' and t.last_req_day='${last_req_date}'
      union all
      select t.device_id, t.device_type
      from dwh.ods_dmp_user_info t
      where t.dt='${ga_date}' and t.business = 'ga' and t.last_req_day='${ga_last_req_date}'
    ) t
    group by t.device_id, t.device_type
  ) a
  join (
    select *
    from dev.dm_interest_tag_orc t
    where concat(t.year, t.month, t.day)='${date}' and t.business='all'
  ) b on a.device_id=b.device_id and a.device_type=b.device_type;

  drop table tmp_interest_tag_daily_${date};
"
hive_cmd "$sql"
if [[ $? -ne 0 ]]; then
    exit 255
fi

hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS
if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "dm_interest_tag_daily" "year='${date:0:4}', month='${date:4:2}', day='${date:6:2}'" "$OUTPUT_PATH"