#!/usr/bin/env bash

source ../../dmp_env.sh
source ./../../ga_rawdata_analysis/common/tools.sh

begin_day=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
end_day=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


check_await "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_dash_today}"

hadoop fs -test -e "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}"
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}"
fi


OUTPUT_PATH01="${TMP_COM_YOUKU_PHONE_WAX_NOBID_PATH}/${dt_dash_today}/01"
OUTPUT_PATH02="${TMP_COM_YOUKU_PHONE_WAX_NOBID_PATH}/${dt_dash_today}/02"

hadoop fs -rm -r "${OUTPUT_PATH01}"
hadoop fs -rm -r "${OUTPUT_PATH02}"

spark-submit --class mobvista.dmp.datasource.dm.YoukuPhoneWaxNobid \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.network.timeout=720s \
 --files ${HIVE_SITE_PATH} \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 6  --num-executors 150 \
 ../../${JAR} -begin_day ${begin_day} -end_day ${end_day} -output01 ${OUTPUT_PATH01}  -output02 ${OUTPUT_PATH02} -coalesce 200


if [[ $? -ne 0 ]]; then
    exit 255
fi

hadoop distcp -m20  "${OUTPUT_PATH01}/*" "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_dash_today}/"
hadoop distcp -m20  "${OUTPUT_PATH02}/*" "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}/"
