#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision: 2017-11-16
# @desc :  将当天3s install用户添加到ods_dmp_user_info表
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

today=${ScheduleTime:-$1}
dt=$(date +"%Y%m%d" -d "-2 day $today")
date=$(date +"%Y-%m-%d" -d "-2 day $today")
date_path=$(date +%Y/%m/%d -d "-2 day $today")
old_path=$(date +%Y/%m/%d -d "-3 day $today")
old_date=$(date +%Y%m%d -d "-3 day $today")
expire_date=$(date +%Y%m%d -d "-6 day $today")
expire_path=$(date +%Y/%m/%d -d "-6 day $today")

business_name="other"
daily_path="${ODS_OTHER_DEVICE_DAILY}/$date_path"
old_total_path=`get_recently_dir "${ODS_DMP_USER_INFO}" "$old_date" "${business_name}"`
OUTPUT_PATH="${ODS_DMP_USER_INFO}/$date_path/${business_name}"
unmount_path="${ODS_DMP_USER_INFO}/$expire_path/${business_name}"
age_path="${AGE_CALC_DEVICE}/$date_path"
gender_path="${GENDER_CALC_DEVICE}/$date_path"
coalesce=`calculate_reduce_num "${old_total_path};${daily_path}"`


hadoop fs -test -e ${daily_path}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${daily_path}
fi

hadoop fs -touchz ${daily_path}/_SUCCESS

userInfoJob "$date" "$daily_path" "text" "0" "1" "2" "3" "$age_path" "$gender_path" "$old_total_path" "$OUTPUT_PATH" ${coalesce} "../${JAR}" 64 640

if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "ods_dmp_user_info" "dt='${dt}', business='${business_name}'" "$OUTPUT_PATH"

unmount_partition "ods_dmp_user_info" "dt='${expire_date}', business='${business_name}'" "${unmount_path}"