#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : ga_install_daily.sh
# @author: houying
# @date  : 16-10-24
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-1 day $ScheduleTime")
old_path=$(date +"%Y/%m/%d" -d "-2 day $ScheduleTime")


INPUT_PATH_INSTALL="${GA_PREPARE_PATH}/$date_path/installation-list"
TMP_OUTPUT_PATH="${TMP_GA_INSTALL_DAILY_PATH}/$date_path"
OUTPUT_PATH="$GA_INSTALL_PATH/$date_path"

echo "INPUT_PATH_INSTALL=$INPUT_PATH_INSTALL"


## check_await "$INPUT_PATH_INSTALL/manifest"


check_await "$INPUT_PATH_INSTALL/_SUCCESS"

hadoop fs -rm -r ${TMP_OUTPUT_PATH}/*

hadoop jar ../${JAR} mobvista.dmp.datasource.ga.mapreduce.GaInstallDailyMR \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  "$INPUT_PATH_INSTALL" "$TMP_OUTPUT_PATH" || exit 1

if [ $? -ne 0 ]; then
    exit 255
fi

# 为bundleId 匹配 packageName
matchBundlePackage "$date_path" "$old_path" "2" "3" "$TMP_OUTPUT_PATH" "$OUTPUT_PATH" "ga" "../${JAR}"


mount_partition "ods_ga_install_daily" "\`date\`='${LOG_TIME}'" "$OUTPUT_PATH"

echo "[Ga Install Daily End!]"

