#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2019-02-27 11:24:06
# @desc : 将 iqiyi 并到安装列表
# # # # # # # # # # # # # # # # # # # # # #

# @update : wangjf

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y%m%d")
dt=$(date -d "$ScheduleTime" +"%Y-%m-%d")

date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")
old_date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

echo ${date_path}
echo ${old_date_path}

business="iqiyi_api"

INPUT_PATH="${IQiYi_DAILY_PATH}/$date_path"

OLD_INPUT_PATH="${DM_INSTALL_LIST}/$old_date_path/${business}"
OUTPUT_PATH="${DM_INSTALL_LIST}/$date_path/${business}"

check_await "$INPUT_PATH/_SUCCESS"
check_await "$OLD_INPUT_PATH/_SUCCESS"

spark-submit --class mobvista.dmp.datasource.iqiyi.IQiYiInstallList \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=20 \
 --master yarn --deploy-mode cluster --name "IQiYiInstallList.${business}" --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 5 \
 --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
 --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
 ../${JAR} -input ${INPUT_PATH} -oldInput ${OLD_INPUT_PATH} -output ${OUTPUT_PATH} -date ${dt} -parallelism 20 -coalesce 20


if [[ $? -ne 0 ]];then
  exit 255
fi

mount_partition "dm_install_list" "year='${LOG_TIME:0:4}', month='${LOG_TIME:4:2}', day='${LOG_TIME:6:2}', business='${business}'" "$OUTPUT_PATH"