#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2019-02-27 11:24:06
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")

date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="joypac_daily"
part='etl'

INPUT_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/stage_joypac_upload_daily/$date_path/*/*.gz"
OUTPUT_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/joypac_result/${date_path}/${part}"

spark-submit --class mobvista.dmp.datasource.joypac.JoypacResultEtl \
    --conf spark.yarn.executor.memoryOverhead=2048  \
    --conf spark.network.timeout=720s \
    --conf spark.default.parallelism=20 \
    --master yarn --deploy-mode cluster --name JoypacResutlEtl \
    --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 5 \
    --files ${HIVE_SITE_PATH} \
    --jars ${JARS} \
    ../${JAR} -input ${INPUT_PATH} -output ${OUTPUT_PATH} -coalesce 10 -date ${LOG_TIME} -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]];then
  exit 255
fi

mount_partition "joypac_result" "dt='${LOG_TIME}',part='${part}'" "$OUTPUT_PATH"