#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :app_tag.sh
# @desc    :app_tag job
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

date=$(date +"%Y-%m-%d" -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")

INPUT_DIM_APP_TAG="${APP_TAG_PATH}/${date_path}"
INPUT_DIM_PACKAGE_TAG="${DIM_PACKAGE_TAGS_PATH}/${date_path}"

check_await ${INPUT_DIM_APP_TAG}/_SUCCESS

output_path="s3://mob-emr-test/dataplatform/data/dwh/app_tag_id/${date_path}"

spark-submit --class mobvista.dmp.datasource.apptag.MergeAppTagID \
     --name "MergeAppTagID_${date}" \
     --conf spark.sql.shuffle.partitions=10 \
     --conf spark.default.parallelism=10 \
     --conf spark.kryoserializer.buffer.max=512m \
     --conf spark.kryoserializer.buffer=64m \
     --conf dfs.socket.timeout=300000 \
     --files ${HIVE_SITE_PATH} \
     --jars ${JARS} \
     --master yarn --deploy-mode cluster --executor-memory 6g --driver-memory 6g  --executor-cores 2  --num-executors 2 \
     ../${JAR} -output ${output_path} -date ${date}

if [[ $? -ne 0 ]]; then
    exit 255
fi