use dev;
drop table dm_device_tag_daily;
create external table dm_device_tag_daily (
  device_id string comment 'device id',
  device_type string comment 'device_type',
  platform string comment 'platform',
  tag_code string comment '标签ID化'
)partitioned by (
  dt string comment '分区字段，yyyyMMdd',
  source string comment '数据来源, manual、dc、toutiao、external',
  business string comment '业务或第三方DMP名称')
stored as orc
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dev/dm_device_tag_daily';

ALTER TABLE dev.dm_active_tag DROP PARTITION (dt='20190318');
ALTER TABLE dev.dm_active_tag ADD IF NOT EXISTS PARTITION (dt='20190322') LOCATION 's3://mob-emr-test/wangjf/dm_active_tag/2019/03/22';

ALTER TABLE dwh.dm_install_list ADD IF NOT EXISTS PARTITION (`year`='2020',`month`='03',`day`='30',business='adn_sdk') LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_install_list/2020/03/30/adn_sdk';

use dwh;
drop table dwh.dm_device_tag_daily;
create external table dwh.dm_device_tag_daily (
  device_id string comment 'device id',
  device_type string comment 'device_type',
  platform string comment 'platform',
  package_name string comment 'package_name',
  tag_code string comment '标签ID化'
)partitioned by (
  dt string comment '分区字段，yyyyMMdd',
  source string comment '数据来源, manual、dc、toutiao、external',
  business string comment '业务或第三方DMP名称')
stored as orc
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_device_tag_daily';

ALTER TABLE dev.dm_interest_tag ADD IF NOT EXISTS PARTITION (`year`='2019',`month`='04',`day`='15',business='all') LOCATION 's3://mob-emr-test/wangjf/dm_interest_tag_orc/2019/04/15/all';

USE dwh;
DROP TABLE dwh.dmp_interest_tag;
CREATE EXTERNAL TABLE dwh.dmp_interest_tag (
  device_id string comment 'device id',
  device_type string comment 'device_type',
  platform string comment 'platform',
  tags string comment 'tags'
) PARTITIONED BY (dt string comment '分区字段，yyyyMMdd')
CLUSTERED BY (device_id) SORTED BY (device_type,platform) INTO 2000 BUCKETS
STORED AS SEQUENCEFILE location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_interest_tag';