#!/bin/bash

######################################################################
# autor: fengliang
# date:  20170831
# desc:  生成月报表
######################################################################
source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
date=$(date +%Y%m%d -d "-2 days $ScheduleTime")
date_path=${date:0:4}/${date:4:2}/${date:6:2}
old_path=$(date +%Y/%m/%d -d "-1 days $ScheduleTime")

REPORT_FILE="${TAG_REPORT_PATH}/${date_path}/DMP各个数据源数据-${date}.xls"

hadoop fs -test -e ${TAG_REPORT_PATH}/${date_path}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${TAG_REPORT_PATH}/${date_path}
fi

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.CreateOtherTable \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  $date $REPORT_FILE
if [ $? -ne 0 ];then
  exit 255
fi

hadoop fs -get $TAG_REPORT_PATH/$old_path/*.xls
if [ $? -ne 0 ];then
  exit 255
fi

hadoop fs -get $REPORT_FILE
if [ $? -ne 0 ];then
  exit 255
fi

files=""
reports=`ls *.xls`
for r in $reports;do
  files="$files,$r"
done

python2.7 ../python/sendMail.py -t 'mingyuan.ren@mobvista.com'  -c 'walt@mobvista.com,feng.liang@mobvista.com,kai.liu@mobvista.com' \
-s "DMP月度运行报表" -b "hi，明远<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;报表数据见附件<br/><br/>" -a ${files:1}
if [ $? -ne 0 ];then
  exit 255
fi