#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :create_table.sh
# @author  :liushuai
# @revision:2017-03-14 20:09
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}
file_dir="s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/four/three"

hadoop fs -get $file_dir/*.txt ./

java -classpath ../${JAR} mobvista.prd.datasource.table.CreateAllGenderAgeTable
if [ $? -ne 0 ];then
  exit 255
fi

java -classpath ../${JAR} mobvista.prd.datasource.table.CreateCountryGenderAgeTable
if [ $? -ne 0 ];then
  exit 255
fi


hadoop fs -mkdir -p s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table

hadoop fs -rm s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table/性别年龄.xls
hadoop fs -put 性别年龄.xls s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table

hadoop fs -rm s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table/*国家的性别年龄.xls
hadoop fs -put *国家的性别年龄.xls s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table