#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :get_m_country.sh
# @author  :liushuai
# @revision:2017-05-17 10:45
# @desc    ：得到3天内M系统设备的country
# # # # # # # # # # # # # # # # # # # # # #


echo "ScheduleTime=$ScheduleTime"

date=$(date +%Y%m%d -d "-8 days $ScheduleTime")

date_path=${date:0:4}/${date:4:2}/${date:6:2}

LOG_TIME=$(date +%Y%m%d -d "-8 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day1=${LOG_TIME:6:2}
LOG_TIME=$(date +%Y%m%d -d "-8 day $ScheduleTime")
day2=${LOG_TIME:6:2}
LOG_TIME=$(date +%Y%m%d -d "-4 day $ScheduleTime")
day3=${LOG_TIME:6:2}

source ../prd_env.sh

M_DAILY_INPUT_PATH="${ETL_ADN_SDK_REQUEST_DAILY}/${year}/${month}/${day2}"
ADN_TOTAL_INPUT_PATH="${ADN_TOTAL_PATH}/${date_path}"
OUTPUT_PATH="${REQUEST_TMP_PATH}/etl_adn_sdk_req_3_day/${date_path}"

hadoop fs -rmr ${OUTPUT_PATH}

REDUCE_NUM=$(calculate_reduce_num "${M_DAILY_INPUT_PATH}")

hadoop jar ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.MergeMInterestDailyMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${M_DAILY_INPUT_PATH} ${ADN_TOTAL_INPUT_PATH} ${OUTPUT_PATH} ${REDUCE_NUM}

if [ $? -ne 0 ];then
  exit 255
fi