package mobvista.dmp.datasource.adn.mapreduce;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import mobvista.dmp.common.CommonMapReduce;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

import java.io.IOException;
import java.util.Set;

/**
 * author: houying
 * date  : 16-10-13
 * desc  :
 */
public class AdnMapper extends Mapper<LongWritable, Text, Text, Text> {
    protected final Joiner joiner = Joiner.on("\t").useForNull("");
    protected String regex = "^[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}$";

    public void handleClick(String[] fields, Context context) throws IOException, InterruptedException {
        /*String timestamp = fields[2];
        String platform = fields[13];
        String osVersion = fields[14];
        String sdkVersion = fields[15];
        String deviceModel = fields[16];
        String screenSize = fields[17];
        String countryCode = fields[19];
        String language = fields[20];
        String mac = fields[36];
        String gaid = fields[42];
        String idfa = fields[43];
        String imei = fields[35];
        String deviceBrand = fields[45];*/

        String timestamp = fields[2];
        String platform = fields[4];
        String osVersion = fields[5];
        String sdkVersion = fields[6];
        String deviceModel = fields[7];
        String screenSize = fields[8];
        String countryCode = fields[9];
        String language = fields[10];
        String mac = fields[13];
        String gaid = fields[15];
        String idfa = fields[16];
        String imei = fields[12];
        String deviceBrand = fields[17];

        // 将UK改为GB，明远需求，修改人冯亮 20170815
        if ("GB".equalsIgnoreCase(countryCode)) {
            countryCode = "UK";
        }

        if (gaid.matches(CommonMapReduce.didPtn)
                && !gaid.matches(CommonMapReduce.allZero)) {
            Text text = new Text(joiner.join("gaid", mac, platform, osVersion, sdkVersion, deviceModel, deviceBrand,
                    screenSize, countryCode, language, timestamp));
            context.write(new Text(gaid), text);
        }
        if (!imei.isEmpty() && imei.matches(CommonMapReduce.imeiPtn)
                && "android".equals(platform)){
            Text text = new Text(joiner.join("imei", mac, platform, osVersion, sdkVersion, deviceModel, deviceBrand,
                    screenSize, countryCode, language, timestamp));
            context.write(new Text(imei), text);
        }
        if (idfa.matches(CommonMapReduce.didPtn)
                && !idfa.matches(CommonMapReduce.allZero)) {
            Text text = new Text(joiner.join("idfa", mac, platform, osVersion, sdkVersion, deviceModel, deviceBrand,
                    screenSize, countryCode, language, timestamp));
            context.write(new Text(idfa), text);
        }
    }
}
