package mobvista.dmp.datasource.dsp.mapreduce;

public class SegmentVO implements Comparable<SegmentVO> {

    private String id;
    private String value;

    public SegmentVO(String id, String value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public int compareTo(SegmentVO o) {
        if (this.id.equals(o.getId())) {
            return this.value.compareTo(o.getValue());
        }
        return this.id.compareTo(o.getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SegmentVO) {
            SegmentVO segmentVO = (SegmentVO) obj;
            return this.id.equals(segmentVO.getId());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append("{ id=").append(this.id).append(", value=").append(this.value).append(" }").toString();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
