package mobvista.dmp.datasource.gender;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.codehaus.jackson.map.ObjectMapper;

import java.io.IOException;

public class GetDspGenderMR {

    /**
     * author:liushuai
     *
     * @throws InterruptedException
     * @throws IOException
     * @throws ClassNotFoundException date   :2017-01-18
     *                                desc  : 清洗每日dsp数据，得到有性别标签的数据
     */

    public static void main(String[] args) throws ClassNotFoundException, IOException, InterruptedException {

        Configuration conf = new Configuration();
        conf.set("mapreduce.map.memory.mb", "1433");
        conf.set("mapreduce.map.speculative", "true");
        conf.set("mapreduce.reduce.speculative", "true");
        conf.set("mapreduce.task.io.sort.mb", "500");
        conf.set("mapreduce.reduce.java.opts", "-Xmx1536m");
        conf.set("mapreduce.reduce.memory.mb", "2048");
        conf.set("mapreduce.reduce.shuffle.parallelcopies", "50");
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

        Job job = Job.getInstance(conf, "DMP-GetDspGenderMR-fengliang");
        FileOutputFormat.setCompressOutput(job, true);
        FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);
        job.setJarByClass(GetDspGenderMR.class);

        job.setMapperClass(GetDspGenderMapper.class);

        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);

        job.setInputFormatClass(TextInputFormat.class);

        FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
        FileOutputFormat.setOutputPath(job, new Path(otherArgs[1]));

        System.exit(job.waitForCompletion(true) ? 0 : 1);

    }

    public static class GetDspGenderMapper extends Mapper<Object, Text, Text, Text> {
        ObjectMapper objectMapper = new ObjectMapper();
        Text outKey = new Text();
        Text outValue = new Text();

        public void map(Object key, Text value, Context context) {
            String line = value.toString();
            //{"platform":"android","time":"2017-02-03 17:07:35","ip":"91.124.126.39","maker":"lenovo","model":"tab2a7-20f","os":"android","os_v":"4.4.2","country":"UA","birthday":"0","gender":"-","dmp_time":"2017-02-03","device_id":"00000e09-0826-4502-b33e-6c05ab66a7a5","device_type":"gaid"}
            try {
                GetDspGenderMould getDspGenderMould = objectMapper.readValue(line, GetDspGenderMould.class);
                String gender = getDspGenderMould.getGender().toLowerCase();
                String deviceId = getDspGenderMould.getDevice_id();
                if (deviceId == null) {
                    return;
                }
                String[] tmpDeviceId = deviceId.split("-", -1);
                if (tmpDeviceId.length <= 1) {
                    return;
                }
                if (deviceId.matches("^0*-0*-0*-0*-0*$")) {
                    return;
                }
                if (gender.toLowerCase().equals("f") || gender.toLowerCase().equals("m")) {//输出有性别的
                    String outputValue = MRUtils.JOINER.join("A", gender, "dsp");
                    outKey.set(deviceId);
                    outValue.set(MRUtils.JOINER.join(outputValue, getDspGenderMould.getDevice_type()));
                    context.write(outKey, outValue);
                }
            } catch (Exception e) {
                return;
            }
        }
    }

}
