package mobvista.dmp.datasource.gender;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

import java.io.IOException;


public class GetGaGenderMR {
    /**
     * author:liushuai
     *
     * @throws InterruptedException
     * @throws IOException
     * @throws ClassNotFoundException date    ：2017-01-18
     *                                desc  : 清洗每日ga数据，得到有性别标签的数据
     */

    public static void main(String[] args) throws ClassNotFoundException, IOException, InterruptedException {

        Configuration conf = new Configuration();
        conf.set("mapreduce.map.speculative", "true");
        conf.set("mapreduce.reduce.speculative", "true");
        conf.set("mapreduce.task.io.sort.mb", "500");
        conf.set("mapreduce.reduce.java.opts", "-Xmx1536m");
        conf.set("mapreduce.reduce.memory.mb", "2048");
        conf.set("mapreduce.reduce.shuffle.parallelcopies", "50");
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

        Job job = Job.getInstance(conf, "GetGaGenderMR");
        FileOutputFormat.setCompressOutput(job, true);
        FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);
        job.setJarByClass(GetDspGenderMR.class);

        job.setMapperClass(GetGaGenderMapper.class);

        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);

        FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
        FileOutputFormat.setOutputPath(job, new Path(otherArgs[1]));

        System.exit(job.waitForCompletion(true) ? 0 : 1);

    }

    public static class GetGaGenderMapper extends Mapper<LongWritable, Text, Text, Text> {
        Text outKey = new Text();
        Text outValue = new Text();

        public void map(LongWritable key, Text value, Context context) {
            try {
                String line = value.toString();
                String[] fields = line.split("\t", -1);
                if (fields.length != 33) {
                    return;
                }
                String[] tmpDeviceId = fields[0].split("-", -1);
                if (tmpDeviceId.length <= 1) {
                    return;
                }
                if (fields[0].matches("^0*-0*-0*-0*-0*$")) {
                    return;
                }
                if (fields[26].toLowerCase().equals("f") || fields[26].toLowerCase().equals("m")) {
                    String outputValue = MRUtils.JOINER.join("A", fields[26].toLowerCase(), "ga", fields[1]);
                    outKey.set(fields[0]);//device_id
                    outValue.set(outputValue);//A,gender,ga,device_type
                    context.write(outKey, outValue);
                }
            } catch (Exception e) {
                return;
            }
        }
    }
}
