package mobvista.dmp.format;

import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.Text;

public class RCFileMultipleOutputForamt extends RCMultipleOutputFormat<Text, BytesRefArrayWritable> {

    @Override
    protected String generateFileNameForKeyValue(Text key, BytesRefArrayWritable value, String name) {
        String temp = key.toString();
        int pos = temp.indexOf(",");
        if (pos != -1) {
            temp = temp.substring(0, pos);
        }
        return temp + "/" + name;
    }

    protected Text generateActualKey(Text key, BytesRefArrayWritable value) {
        String temp = key.toString();
        int pos = temp.indexOf(",");
        if (pos == -1)
            return key;
        String outKey = temp.substring(pos + 1).trim();
        if ("".equals(outKey)) {
            return null;
        }
        return new Text(temp.substring(pos + 1));
    }
}
