package mobvista.prd.datasource.newall;

import mobvista.prd.datasource.util.MRUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

import java.io.IOException;

/**
 * Created by Administrator on 2017/4/28 0028.
 */
public class AlreadyHiveMR {
    public static void main(String[] args) throws InterruptedException, IOException, ClassNotFoundException {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

        Job job = Job.getInstance(conf, "AlreadyHiveMR");
        job.setNumReduceTasks(1);
        job.setJarByClass(AlreadyHiveMR.class);
        FileOutputFormat.setCompressOutput(job, true);
        FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);

        job.setMapperClass(TrackingInstallDailyMapper.class);
        job.setReducerClass(TrackingInstallDailyReducer.class);

        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(NullWritable.class);

        FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
        FileInputFormat.addInputPath(job, new Path(otherArgs[1]));
        FileInputFormat.addInputPath(job, new Path(otherArgs[2]));
        FileInputFormat.addInputPath(job, new Path(otherArgs[3]));
        FileOutputFormat.setOutputPath(job, new Path(otherArgs[4]));

        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class TrackingInstallDailyMapper extends Mapper<LongWritable, Text, Text, NullWritable> {
        Text outKey = new Text();
        Text outValue = new Text();
        Long man = 0L;
        Long nv = 0L;
        Long one = 0L;
        Long two = 0L;
        Long three = 0L;
        Long four = 0L;
        Long five = 0L;
        public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            String line = value.toString();
            String[] fields = MRUtils.SPLITTER.split(line,-1);
            if (fields[2].equals("f")) {
                nv++;
            }
            if (fields[2].equals("m")) {
                man++;
            }
            if (fields[2].equals("1")) {
                one++;
            }
            if (fields[2].equals("2")) {
                two++;
            }
            if (fields[2].equals("3")) {
                three++;
            }
            if (fields[2].equals("4")) {
                four++;
            }
            if (fields[2].equals("5")) {
                five++;
            }

        }
        public void cleanup(Context context) throws IOException, InterruptedException {
            outKey.set(MRUtils.JOINER.join(man,nv,one,two,three,four,five));
            context.write(outKey,NullWritable.get());
        }

    }

    public static class TrackingInstallDailyReducer extends Reducer<Text, Text, Text, NullWritable> {
        Text outKey = new Text();
        Long man = 0L;
        Long nv = 0L;
        Long one = 0L;
        Long two = 0L;
        Long three = 0L;
        Long four = 0L;
        Long five = 0L;
        public void reduce(Text key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
            String[] fields = key.toString().split("\t",-1);
            man = Integer.parseInt(fields[0]) + man;
            nv = Integer.parseInt(fields[1]) + nv;
            one = Integer.parseInt(fields[2]) + one;
            two = Integer.parseInt(fields[3]) + two;
            three = Integer.parseInt(fields[4]) + three;
            four = Integer.parseInt(fields[5]) + four;
            five = Integer.parseInt(fields[6]) + five;
        }
        public void cleanup(Context context) throws IOException, InterruptedException {
            outKey.set(MRUtils.JOINER.join(man,nv,one,two,three,four,five));
            context.write(outKey,NullWritable.get());
        }
    }
}
