package mobvista.prd.datasource.source.mapreduce;

import mobvista.prd.datasource.dao.ExportExcelDAO;
import mobvista.prd.datasource.dao.impl.ExportExcelDAOImpl;
import mobvista.prd.datasource.main.GenerateTagReport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.*;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 生成月报表
 * Created by Administrator on 2017/6/16 0016.
 */
public class CreateOtherTable {
    private static final Logger log = Logger.getLogger(CreateOtherTable.class);

    private List<String> croessColumns = new ArrayList<>();
    private List<String> croessHeadColumns = new ArrayList<String>();
    private List<String> newAddColumns = new ArrayList<String>();
    private List<String> newAddHeadColumns = new ArrayList<String>();
    private List<String> dauColumns = new ArrayList<String>();
    private List<String> dauHeadColumns = new ArrayList<String>();

    private List<String> idsColumns = new ArrayList<>();
    private List<String> idsHeadColumns = new ArrayList<String>();

    public void init () {
        croessHeadColumns.add("数据源");
        croessHeadColumns.add("设备量");

        croessColumns.add("dimension_type2");
        croessColumns.add("video_value");


        newAddHeadColumns.add("数据源");
        newAddHeadColumns.add("设备量");

        newAddColumns.add("dimension_type2");
        newAddColumns.add("video_value");


        dauHeadColumns.add("数据源");
        dauHeadColumns.add("设备量");

        dauColumns.add("dimension_type2");
        dauColumns.add("video_value");


        idsHeadColumns.add("ID类型");
        idsHeadColumns.add("DAU");
        idsHeadColumns.add("新增");

        idsColumns.add("dimension_type2");
        idsColumns.add("dau");
        idsColumns.add("new");

    }

    public int run (String[] args) throws Exception {
        if (args.length < 2) {
            log.info("Usage: GenerateTagReport <date> <output>");
            return 1;
        }

        init();

        OutputStream out = null;
        try {
            String date = args[0];
            String output = args[1];
            Path reportFile = new Path(output);
            FileSystem fs = FileSystem.get(URI.create(output), new Configuration());
            out = fs.create(reportFile);
//            out = new FileOutputStream(output);

            ExportExcelDAO dao = new ExportExcelDAOImpl();
            List<Map<String, Object>> croessList = dao.findSourcesData(date, "DMP交叉数据");
            List<Map<String, Object>> newAddList = dao.findSourcesData(date, "DMP新增数据");
            List<Map<String, Object>> dauList = dao.findSourcesData(date, "DMP日活数据");
            List<Map<String, Object>> idsList = dao.findIdsData(date);


            HSSFWorkbook workbook = new HSSFWorkbook();
            buildExcel(workbook, "交叉数据", croessHeadColumns, croessColumns, croessList);
            buildExcel(workbook, "新增数据", newAddHeadColumns, newAddColumns, newAddList);
            buildExcel(workbook, "日活数据", dauHeadColumns, dauColumns, dauList);
            buildExcel(workbook, "各ID数据", idsHeadColumns, idsColumns, idsList);

            workbook.write(out);
        } catch (Exception e) {
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }

        return 0;
    }

    public void buildExcel(HSSFWorkbook workbook, String sheetName, List<String> headColumns, List<String> columns,
                           List<Map<String, Object>> dataColumns) {

        HSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);

        HSSFFont headFont = workbook.createFont();
        headFont.setBold(true);
        headFont.setFontHeightInPoints((short) 12);

        HSSFCellStyle headStyle = workbook.createCellStyle();
        headStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        headStyle.setFont(headFont);

        HSSFRow head = sheet.createRow(0);
        for (int i = 0; i < headColumns.size(); i++) {
            HSSFCell cell = head.createCell(i);
            cell.setCellStyle(headStyle);
            cell.setCellValue(headColumns.get(i));
        }

        Map<String, Object> map = null;
        for (int i=0; i< dataColumns.size(); i++) {
            map = dataColumns.get(i);
            HSSFRow row = sheet.createRow(i + 1);
            for (int j=0; j<columns.size(); j++) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(String.valueOf(map.get(columns.get(j))));
            }
        }
    }


    public static void main(String[] args) {
        try {
            new CreateOtherTable().run(args);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}
