package mobvista.dmp.clickhouse.adn_report

import org.apache.spark.sql.Row
import org.apache.spark.sql.types.{DoubleType, IntegerType, LongType, StringType, StructField, StructType}

/**
  * @package: mobvista.dmp.clickhouse
  * @author: wangjf
  * @date: 2020/2/19
  * @time: 5:46 下午
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
object Constant {

  val ss_creative_report_hour_sql: String =
    """
      |SELECT * FROM adn_seesaw.ss_creative_report_hour WHERE pdate = '@date'
      |""".stripMargin

  val indexColumn_ss_creative_report_hour: Seq[String] = Seq("date", "timestamp", "timestamp2", "conversion_time", "country_code",
    "adv_offer_id", "adv_user_id", "package_name", "sub_id", "ad_type", "creative_id", "endcard_id", "endcard_type",
    "endcard_group", "adv_install", "adv_original_money", "adv_click", "adv_impression", "app_id", "scenario", "publisher_id",
    "creative_from", "creative_name", "phour", "ptype")

  //  val orderColumn_adn_report_hour: Seq[String] = Seq("device_id", "platform")

  val adx_report_hour_sql: String =
    """
      |
      |""".stripMargin

  val indexColumn_adx_report_hour: Seq[String] = Seq("date", "timestamp", "timestamp2", "conversion_time", "country_code",
    "adv_offer_id", "adv_user_id", "package_name", "sub_id", "ad_type", "creative_id", "endcard_id", "endcard_type",
    "endcard_group", "adv_install", "adv_original_money", "adv_click", "adv_impression", "app_id", "scenario", "publisher_id",
    "creative_from", "creative_name", "phour", "ptype")

  val sql: String =
    """
      |
      |""".stripMargin

  def precess(row: Row, table: String) = {
    val product = table match {
      case "ss_creative_report_hour" =>
        Row(row.getAs("date"), row.getAs("timestamp"), row.getAs("timestamp2"),
          row.getAs("conversion_time"), row.getAs("country_code"), row.getAs("adv_offer_id"),
          row.getAs("adv_user_id"), row.getAs("package_name"), row.getAs("sub_id"),
          row.getAs("ad_type"), row.getAs("creative_id"), row.getAs("endcard_id"),
          row.getAs("endcard_type"), row.getAs("endcard_group"), row.getAs("adv_install"),
          row.getAs("adv_original_money"), row.getAs("adv_click"), row.getAs("adv_impression"),
          row.getAs("app_id"), row.getAs("scenario"), row.getAs("publisher_id"),
          row.getAs("creative_from"), row.getAs("creative_name"), row.getAs("phour"), row.getAs("ptype"))
      case "adx_report_hour" =>
        Row(row.getAs(0), row.getAs(1), row.getAs(2))
    }
    product
  }


  def getSchema(table: String) = {
    table match {
      case "ss_creative_report_hour" =>
        ss_creative_report_hour_schema
      case "adx_report_hour" =>
        ss_creative_report_hour_schema
    }
  }

  def getIndexColumn(table: String): Seq[String] = {
    val indexColumn = table match {
      case "ss_creative_report_hour" =>
        Constant.indexColumn_ss_creative_report_hour
      case "adx_report_hour" =>
        Constant.indexColumn_adx_report_hour
    }
    indexColumn
  }

  val ss_creative_report_hour_schema = StructType(Array(
    StructField("date", IntegerType, true),
    StructField("timestamp", IntegerType, true),
    StructField("timestamp2", IntegerType, true),
    StructField("conversion_time", IntegerType, true),
    StructField("country_code", StringType, true),
    StructField("adv_offer_id", LongType, true),
    StructField("adv_user_id", IntegerType, true),
    StructField("package_name", StringType, true),
    StructField("sub_id", StringType, true),
    StructField("ad_type", StringType, true),
    StructField("creative_id", LongType, true),
    StructField("endcard_id", LongType, true),
    StructField("endcard_type", LongType, true),
    StructField("endcard_group", IntegerType, true),
    StructField("adv_install", LongType, true),
    StructField("adv_original_money", DoubleType, true),
    StructField("adv_click", LongType, true),
    StructField("adv_impression", LongType, true),
    StructField("app_id", IntegerType, true),
    StructField("scenario", StringType, true),
    StructField("publisher_id", IntegerType, true),
    StructField("creative_from", StringType, true),
    StructField("creative_name", StringType, true),
    StructField("phour", StringType, true),
    StructField("ptype", StringType, true)
  ))
}
