package mobvista.dmp.datasource.apptag

import java.util.Properties

import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * @package: mobvista.dmp.datasource.apptag
  * @author: wangjf
  * @date: 2019-07-19
  * @time: 11:04
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
object Constant {

  def jdbcConnection(spark: SparkSession, database: String, table: String, url: String, user: String, password: String): DataFrame = {
    val properties = new Properties()
    properties.put("driver", "com.mysql.jdbc.Driver")
    properties.put("user", user)
    properties.put("password", password)
    properties.put("characterEncoding", "utf8")

    spark.read.jdbc(url = s"${url}/${database}", table = table, properties = properties)
  }

  val ods2new_sql: String =
    """
      |SELECT tag_type, first_tag, second_tag, new_first_id, new_second_id FROM
      | dwh.dm_old2new_tag
    """.stripMargin

  val old_new_sql: String =
    """
      |SELECT UPPER(CONCAT(tag_type, '-', first_tag, '-', second_tag)) tag_code, new_second_id FROM
      | dwh.dm_old2new_tag
    """.stripMargin
}
