package mobvista.dmp.datasource.clever

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * @package: mobvista.dmp.datasource.adn
  * @author: wangjf
  * @date: 2019/3/19
  * @time: 下午1:51
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class AdnCleverTagDaily extends MatchInterestTagDaily with Serializable {
  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val sql = Constant.clever_sql.replace("@dt", date)
    spark.sql(sql)
  }
}

object AdnCleverTagDaily{
  def main(args: Array[String]): Unit = {
    new AdnCleverTagDaily().run(args)
  }
}