package mobvista.dmp.datasource.dsp

import java.text.SimpleDateFormat
import java.util

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily, TagDaily}
import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils
import org.apache.spark.sql.{DataFrame, SparkSession}

import scala.collection.mutable.ArrayBuffer
import scala.collection.JavaConversions._

/**
  * @package: mobvista.dmp.datasource.dsp
  * @author: wangjf
  * @date: 2019/3/18
  * @time: 下午6:23
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class DspReqTagDaily extends MatchInterestTagDaily with Serializable {
  val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
  val sdf2 = new SimpleDateFormat("yyyyMMdd")

  override def processDailyData(date: String, spark: SparkSession): DataFrame = {

    val dt = sdf1.format(sdf2.parse(date))
    val sql = Constant.dsp_req_sql.replace("@dt", dt)

    val rdd = spark.sql(sql).rdd.mapPartitions(rs => {
      rs.map(r => {
        TagDaily(r.getAs("device_id"), r.getAs("device_type"), r.getAs("platform"), r.getAs("package_list"))
      })
    }).flatMap(r => {
      val buffer = new ArrayBuffer[TagDaily]()
      val device_id = r.device_id
      val device_type = r.device_type
      val platform = r.platform
      val package_list = r.package_name
      if (StringUtils.isNotBlank(package_list) && package_list.startsWith("[") && package_list.endsWith("]")) {
        val jsonArray = GsonUtil.String2JsonArray(package_list)
        val set = GsonUtil.fromJson(jsonArray, classOf[util.HashSet[String]])
        set.map(package_name => {
          buffer += TagDaily(device_id, device_type, platform, package_name)
        })
      }
      buffer
    })
    import spark.implicits._
    rdd.toDF
  }
}

object DspReqTagDaily {
  def main(args: Array[String]): Unit = {
    new DspReqTagDaily().run(args)
  }
}