package mobvista.dmp.datasource.fmp

import java.net.URI
import java.text.SimpleDateFormat
import java.util.{Calendar, Date}

import mobvista.dmp.common.CommonSparkJob
import mobvista.dmp.util.JdbcUtils
import org.apache.commons.cli.{BasicParser, Options}
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.hadoop.io.compress.GzipCodec
import org.apache.spark.sql.SparkSession

/**
  * @package: mobvista.dmp.datasource.fmp
  * @author: wangjf
  * @date: 2019-06-10
  * @time: 16:45
  * @emial: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class FmpInsightJob extends CommonSparkJob {
  def commandOptions(): Options = {
    val options = new Options()
    options.addOption("data", true, "data")
    options.addOption("output", true, "output")
    options.addOption("coalesce", true, "coalesce")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val parser = new BasicParser()
    val options = commandOptions()
    val commandLine = parser.parse(options, args)
    var data = commandLine.getOptionValue("data")
    var output = commandLine.getOptionValue("output")
    val coalesce = commandLine.getOptionValue("coalesce")
    val spark = SparkSession
      .builder()
      .appName("FmpInsightJob")
      .config("spark.rdd.compress", "true")
      .config("spark.shuffle.compress", "true")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.io.compression.codec", "lz4")
      .config("spark.io.compression.lz4.blockSize", "64k")
      .config("spark.sql.autoBroadcastJoinThreshold", "209715200")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()
    try {

      data = data.replaceAll("""\\\"""","""\\""").replaceAll("""\\""", """\\\"""")
      val jobProfileEntity: JobProfileEntity = Constant.parseJsonStringJob(data.replaceAll("#*#", " "))

      val job_id = jobProfileEntity.job_id

      output = output + "/" + job_id
      FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output), true)

      val dfc = Constant.getDF(spark, jobProfileEntity)

      dfc._1.rdd.map(r => {
        r.getAs(0).toString
      }).coalesce(coalesce.toInt).saveAsTextFile(output, classOf[GzipCodec])

      val sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
      val return_data_num = dfc._2
      val jdbcUtils = new JdbcUtils
      val connection = jdbcUtils.getConnection("dmp_fmp")

      val cal = Calendar.getInstance()
      cal.setTime(new Date())
      cal.add(Calendar.HOUR, 13)
      val update_time = sdf.format(cal.getTime)
      val sql =
        s"""
           |UPDATE dmp_fmp.job_profile SET return_data_num = ${return_data_num}, path = '${output}', flag = 1, update_time = '${update_time}' WHERE job_id = '${job_id}'
      """.stripMargin
      println("更新:==>>" + jdbcUtils.update(sql))

    } finally {
      if (spark != null) {
        spark.stop()
      }
    }
    0
  }
}

object FmpInsightJob {
  def main(args: Array[String]): Unit = {
    new FmpInsightJob().run(args)
  }
}