package mobvista.dmp.datasource.mpsdk

import java.util

import mobvista.prd.datasource.util.GsonUtil

class InstallInfo(package_name : String, date : String) extends Serializable with Comparable[InstallInfo] {

  override
  def equals(obj: scala.Any): Boolean = {
    if (obj.isInstanceOf[InstallInfo]) {
      return package_name.equals(obj.asInstanceOf[InstallInfo].getPackage_name())
    }
    false
  }

  override def hashCode(): Int = {
    this.package_name.hashCode
  }

  def getPackage_name (): String = {
    return this.package_name
  }

  def getDate(): String = {
    return this.date
  }

  override def compareTo(o: InstallInfo): Int = {
    if (package_name.equals(o.getPackage_name())) {
      return date.compareTo(o.getDate())
    } else {
      return package_name.compareTo(o.getPackage_name())
    }
  }

  override def toString = {
    s"{package_name = $package_name, date = $date}"
  }
}

object InstallInfo {
  def main(args: Array[String]): Unit = {
    var v1 = new InstallInfo("1", "20170909")
    var v2 = new InstallInfo("2", "20170909")
    var c = new InstallInfo("1", "20170917")

//    val map = new java.util.HashMap[String, InstallInfo]()
//    map.put("1", v1)
//    map.put("2", v2)
//    if (c != null) {
//      var installInfo = map.get(c.getPackage_name())
//      if (installInfo != null) {
//        if (installInfo.compareTo(c) < 0) {
//          map.put(c.getPackage_name(), c)
//        }
//      } else {
//        map.put(c.getPackage_name(), c)
//      }
//    }
//   println(GsonUtil.toJson(map.values()).toString)

    val set = new util.HashSet[InstallInfo]()
    set.add(c)
    set.add(v1)
    println(GsonUtil.toJson(set).toString)
  }
}
