package mobvista.dmp.datasource.newtag

import org.apache.hadoop.io.Text
import org.apache.orc.TypeDescription
import org.apache.orc.mapred.OrcStruct
import org.apache.spark.sql.Row

/**
  * @package: mobvista.dmp.datasource.newtag
  * @author: wangjf
  * @date: 2019/3/18
  * @time: 下午3:16
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class CustomIteratorDaily(iter: Iterator[Row]) extends Iterator[(Text, OrcStruct)] {
  val schema = "struct<device_id:string,device_type:string,platform:string,package_name:string,tag_code:string>"

  def hasNext: Boolean = {
    iter.hasNext
  }

  def next: (Text, OrcStruct) = {
    val row = iter.next
    val deviceId = row.getAs("device_id").toString.toLowerCase
    val deviceType = row.getAs("device_type").toString
    val platform = row.getAs("platform").toString
    val package_name = row.getAs("package_name").toString
    val tagCode = row.getAs("tag_code").toString
    val path = row.getAs("path").toString

    val struct = OrcStruct.createValue(TypeDescription.fromString(schema)).asInstanceOf[OrcStruct]
    struct.setFieldValue(0, new Text(deviceId))
    struct.setFieldValue(1, new Text(deviceType))
    struct.setFieldValue(2, new Text(platform))
    struct.setFieldValue(3, new Text(package_name))
    struct.setFieldValue(4, new Text(tagCode))
    (new Text(path), struct)
  }
}