package mobvista.dmp.datasource.taobao

import java.net.URI

import com.alibaba.fastjson.{JSON, JSONArray, JSONObject}
import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.hadoop.io.compress.GzipCodec
import org.apache.spark.sql.SparkSession

import scala.collection.mutable.ArrayBuffer

class YoukuTmpDataToDmp extends CommonSparkJob with Serializable {
  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("Input", true, "[must] Input")
    options.addOption("Output", true, "[must] Output")
    options.addOption("update", true, "[must] update")
    options
  }

  private def buildRes(row: String,update: String):Array[String]={
    val result = ArrayBuffer[String]()
    val jsonData: JSONObject =  JSON.parseObject(row)
    val array: JSONArray = jsonData.getJSONArray("queryItems")

    val nObject: JSONObject = array.getJSONObject(0)
    val matchState = nObject.getString("matchState")
    val deviceInfo: JSONObject = nObject.getJSONObject("deviceInfo")
    val platform="android"
    if (!(deviceInfo.getString("hashImei") == null) ) {
      val deviceId: String = deviceInfo.getString("hashImei")
      if(matchState.equals("0")) {
        result += deviceId + "\t" + "imeimd5" + "\t" + platform + "\t" + "com.youku.foracquisition_imei" + "\t" + update
      }else if(matchState.equals("1")) {
        result += deviceId + "\t" + "imeimd5" + "\t" + platform + "\t" + "com.youku.noforacquisition_imei" + "\t" + update
        result += deviceId + "\t" + "imeimd5" + "\t" + platform + "\t" + "com.youku.phone" + "\t" + update
      }
    }
    if (!(deviceInfo.getString("hashOaid") == null) ) {
      val deviceId: String = deviceInfo.getString("hashOaid")
      if(matchState.equals("0")) {
        result += deviceId + "\t" + "oaidmd5" + "\t" + platform + "\t" + "com.youku.foracquisition_oaid" + "\t" + update
      }else if(matchState.equals("1")) {
        result += deviceId + "\t" + "oaidmd5" + "\t" + platform + "\t" + "com.youku.noforacquisition_oaid" + "\t" + update
        result += deviceId + "\t" + "oaidmd5" + "\t" + platform + "\t" + "com.youku.phone" + "\t" + update
      }
    }
    result.toArray
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)

    val Input = commandLine.getOptionValue("Input")
    val Output = commandLine.getOptionValue("Output")
    val update = commandLine.getOptionValue("update")

    val spark = SparkSession.builder()
      .appName("YoukuTmpDataToDmp")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()

    val sc = spark.sparkContext
    import spark.implicits._

    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(Output), true)

    try {
      //      如果alipay_imei_lahuo_request  请求任务中途失败，为了重跑时，不用删除clickhouse存储的部分结果数据，加上distinct对结果数据去重
     sc.textFile(Input).filter(_.contains("\"queryItems\":[{\"deviceInfo\"")).flatMap(buildRes(_,update)).distinct().coalesce(200).saveAsTextFile(Output, classOf[GzipCodec])

    } finally {
      spark.stop()
    }
    0
  }
}

object YoukuTmpDataToDmp {
  def main(args: Array[String]): Unit = {
    new YoukuTmpDataToDmp().run(args)
  }
}
