/*
 * Decompiled with CFR 0.152.
 */
package io.clickhouse.spark.connection;

import io.clickhouse.spark.connection.JdbcConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import shade.io.clickhouse.apache.commons.pool2.KeyedPooledObjectFactory;
import shade.io.clickhouse.apache.commons.pool2.PooledObject;
import shade.io.clickhouse.apache.commons.pool2.impl.DefaultPooledObject;
import shade.io.clickhouse.apache.commons.pool2.impl.GenericKeyedObjectPool;
import shade.io.clickhouse.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001-\u0011QcQ8o]\u0016\u001cG/[8o!>|G.\u001a3E\u0005V\u0013HN\u0003\u0002\u0004\t\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003)\u0019G.[2lQ>,8/\u001a\u0006\u0002\u0013\u0005\u0011\u0011n\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M9R\"\u0001\u000b\u000b\u0005%)\"\"\u0001\f\u0002\t)\fg/Y\u0005\u00031Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u000bI\u0006$\u0018mU8ve\u000e,W#\u0001\u000f\u0011\tu\u00013e\t\b\u0003\u001byI!a\b\b\u0002\rA\u0013X\rZ3g\u0013\t\t#EA\u0002NCBT!a\b\b\u0011\u0005u!\u0013BA\u0013#\u0005\u0019\u0019FO]5oO\"Aq\u0005\u0001B\u0001B\u0003%A$A\u0006eCR\f7k\\;sG\u0016\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\u0015\u0011\u0014\u0018N^3s\u001d\u0006lW-F\u0001$\u0011!a\u0003A!A!\u0002\u0013\u0019\u0013a\u00033sSZ,'OT1nK\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\taL\u0001\u0011a>|GnU5{KB+Go\u00155be\u0012,\u0012\u0001\r\t\u0003\u001bEJ!A\r\b\u0003\u0007%sG\u000f\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0003E\u0001xn\u001c7TSj,\u0007+\u001a;TQ\u0006\u0014H\r\t\u0005\tm\u0001\u0011)\u0019!C\u0001_\u0005y1o\\2lKR$\u0016.\\3pkRl5\u000f\u0003\u00059\u0001\t\u0005\t\u0015!\u00031\u0003A\u0019xnY6fiRKW.Z8vi6\u001b\b\u0005C\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0006yyz\u0004)\u0011\t\u0003{\u0001i\u0011A\u0001\u0005\u00065e\u0002\r\u0001\b\u0005\u0006Se\u0002\ra\t\u0005\u0006]e\u0002\r\u0001\r\u0005\u0006me\u0002\r\u0001\r\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0003\raujR\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0006g24GG\u001b\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051;%A\u0002'pO\u001e,'\u000f\u0003\u0004O\u0001\u0001\u0006I!R\u0001\u0005\u0019>;\u0005\u0005C\u0004Q\u0001\t\u0007I\u0011B)\u0002\r\u0011\u0014\u0018N^3s+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+\u0016\u0003\r\u0019\u0018\u000f\\\u0005\u0003/R\u0013a\u0001\u0012:jm\u0016\u0014\bBB-\u0001A\u0003%!+A\u0004ee&4XM\u001d\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003AV\tA!\u001e;jY&\u0011!m\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u00023\u0001A\u0003%Q,A\u000bd_:tWm\u0019;j_:\u0004&o\u001c9feRLWm\u001d\u0011\t\u000f\u0019\u0004!\u0019!C\u0005O\u0006!\u0001o\\8m+\u0005A\u0007\u0003B5sGQl\u0011A\u001b\u0006\u0003W2\fA![7qY*\u0011QN\\\u0001\u0006a>|GN\r\u0006\u0003_B\fqaY8n[>t7O\u0003\u0002r\u0013\u00061\u0011\r]1dQ\u0016L!a\u001d6\u0003-\u001d+g.\u001a:jG.+\u00170\u001a3PE*,7\r\u001e)p_2\u0004\"!P;\n\u0005Y\u0014!A\u0004&eE\u000e\u001cuN\u001c8fGRLwN\u001c\u0005\u0007q\u0002\u0001\u000b\u0011\u00025\u0002\u000bA|w\u000e\u001c\u0011\t\u000bi\u0004A\u0011A>\u0002\u001b\u001d,GoQ8o]\u0016\u001cG/[8o)\t!H\u0010C\u0003~s\u0002\u00071%A\u0003tQ\u0006\u0014H\r\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0012e\u0016dW-Y:f\u0007>tg.Z2uS>tG\u0003BA\u0002\u0003\u0013\u00012!DA\u0003\u0013\r\t9A\u0004\u0002\u0005+:LG\u000f\u0003\u0004\u0002\fy\u0004\r\u0001^\u0001\u0004G>t\u0007bBA\b\u0001\u0011\r\u0011\u0011C\u0001\u000fMVt7\rV8Sk:t\u0017M\u00197f)\u0011\t\u0019\"a\b\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007\u0016\u0003\u0011a\u0017M\\4\n\t\u0005u\u0011q\u0003\u0002\t%Vtg.\u00192mK\"A\u0011\u0011EA\u0007\u0001\u0004\t\u0019#\u0001\u0003gk:\u001c\u0007#B\u0007\u0002&\u0005\r\u0011bAA\u0014\u001d\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003\u0015\u0019Gn\\:f)\t\t\u0019A\u0002\u0004\u00022\u0001!\u00111\u0007\u0002\u0010!>|G.\u00192mK\u001a\u000b7\r^8ssN1\u0011qFA\u001b\u0003w\u0001B!!\u0006\u00028%!\u0011\u0011HA\f\u0005\u0019y%M[3diB1\u0011QHA GQl\u0011\u0001\\\u0005\u0004\u0003\u0003b'\u0001G&fs\u0016$\u0007k\\8mK\u0012|%M[3di\u001a\u000b7\r^8ss\"9!(a\f\u0005\u0002\u0005\u0015CCAA$!\u0011\tI%a\f\u000e\u0003\u0001A\u0001\"!\u0014\u00020\u0011\u0005\u0013qJ\u0001\u000b[\u0006\\Wm\u00142kK\u000e$H\u0003BA)\u0003/\u0002R!!\u0010\u0002TQL1!!\u0016m\u00051\u0001vn\u001c7fI>\u0013'.Z2u\u0011\u0019i\u00181\na\u0001G!2\u00111JA.\u0003O\u0002R!DA/\u0003CJ1!a\u0018\u000f\u0005\u0019!\bN]8xgB\u00191+a\u0019\n\u0007\u0005\u0015DK\u0001\u0007T#2+\u0005pY3qi&|g.\r\u0004\u001fG\u0005%\u0014\u0011T\u0019\nG\u0005-\u0014\u0011OAH\u0003g*2AKA7\t\u001d\tyG\u0003b\u0001\u0003s\u0012\u0011\u0001V\u0005\u0005\u0003g\n)(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003or\u0011A\u0002;ie><8/\u0005\u0003\u0002|\u0005\u0005\u0005cA\u0007\u0002~%\u0019\u0011q\u0010\b\u0003\u000f9{G\u000f[5oOB!\u00111QAE\u001d\ri\u0011QQ\u0005\u0004\u0003\u000fs\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u000biIA\u0005UQJ|w/\u00192mK*\u0019\u0011q\u0011\b2\u0013\r\n\t*a%\u0002\u0016\u0006]dbA\u0007\u0002\u0014&\u0019\u0011q\u000f\b2\u000b\tja\"a&\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n\t\u0007\u0003\u0005\u0002\u001e\u0006=B\u0011IAP\u00035!Wm\u001d;s_f|%M[3diR1\u00111AAQ\u0003KCq!a)\u0002\u001c\u0002\u00071%A\u0002lKfD\u0001\"a*\u0002\u001c\u0002\u0007\u0011\u0011K\u0001\u0004_\nT\u0007FBAN\u00037\nY+\r\u0004\u001fG\u00055\u00161W\u0019\nG\u0005-\u0014\u0011OAX\u0003g\n\u0014bIAI\u0003'\u000b\t,a\u001e2\u000b\tja\"a&2\u0007\u0019\n\t\u0007\u0003\u0005\u00028\u0006=B\u0011IA]\u000391\u0018\r\\5eCR,wJ\u00196fGR$b!a/\u0002B\u0006\r\u0007cA\u0007\u0002>&\u0019\u0011q\u0018\b\u0003\u000f\t{w\u000e\\3b]\"9\u00111UA[\u0001\u0004\u0019\u0003\u0002CAT\u0003k\u0003\r!!\u0015\t\u0011\u0005\u001d\u0017q\u0006C!\u0003\u0013\fa\"Y2uSZ\fG/Z(cU\u0016\u001cG\u000f\u0006\u0004\u0002\u0004\u0005-\u0017Q\u001a\u0005\b\u0003G\u000b)\r1\u0001$\u0011!\ty-!2A\u0002\u0005E\u0013AB8cU\u0016\u001cG\u000f\u0003\u0005\u0002T\u0006=B\u0011IAk\u0003=\u0001\u0018m]:jm\u0006$Xm\u00142kK\u000e$HCBA\u0002\u0003/\fI\u000eC\u0004\u0002$\u0006E\u0007\u0019A\u0012\t\u0011\u0005=\u0017\u0011\u001ba\u0001\u0003#\u0002")
public class ConnectionPooledDBUrl
implements Serializable {
    private final Map<String, String> dataSource;
    private final String driverName;
    private final int poolSizePetShard;
    private final int socketTimeoutMs;
    private final Logger io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG;
    private final Driver io$clickhouse$spark$connection$ConnectionPooledDBUrl$$driver;
    private final Properties io$clickhouse$spark$connection$ConnectionPooledDBUrl$$connectionProperties;
    private final GenericKeyedObjectPool<String, JdbcConnection> io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool;

    public Map<String, String> dataSource() {
        return this.dataSource;
    }

    public String driverName() {
        return this.driverName;
    }

    public int poolSizePetShard() {
        return this.poolSizePetShard;
    }

    public int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public Logger io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG() {
        return this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG;
    }

    public Driver io$clickhouse$spark$connection$ConnectionPooledDBUrl$$driver() {
        return this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$driver;
    }

    public Properties io$clickhouse$spark$connection$ConnectionPooledDBUrl$$connectionProperties() {
        return this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$connectionProperties;
    }

    public GenericKeyedObjectPool<String, JdbcConnection> io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool() {
        return this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool;
    }

    public JdbcConnection getConnection(String shard) {
        try {
            return this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool().borrowObject(shard);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Exception while getting DB connection:  Cannot connect to database server: %s, url: %s", shard, this.dataSource().get((Object)shard)), exception);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw noSuchElementException;
        }
    }

    public void releaseConnection(JdbcConnection con) {
        try {
            this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool().returnObject(con.shard(), con);
        }
        catch (Exception exception) {
            this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().warn("Can not close connection.", (Throwable)exception);
        }
    }

    public Runnable funcToRunnable(Function0<BoxedUnit> func) {
        return this.funcToRunnable((Function0<BoxedUnit>)new scala.Serializable(this, func){
            public static final long serialVersionUID = 0L;
            private final Function0 func$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public void close() {
        new Thread(this.funcToRunnable((Function0<BoxedUnit>)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionPooledDBUrl $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                try {
                    GenericKeyedObjectPool<String, JdbcConnection> p = this.$outer.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool();
                    this.$outer.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().debug(">>>> Clearing pool, active: {}, idle: {}", (Object)BoxesRunTime.boxToInteger((int)p.getNumActive()), (Object)BoxesRunTime.boxToInteger((int)p.getNumIdle()));
                    p.clear();
                    while (true) {
                        if (p.getNumActive() <= 0) {
                            this.$outer.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().debug(">>>> Closing pool, active: {}, idle: {}", (Object)BoxesRunTime.boxToInteger((int)p.getNumActive()), (Object)BoxesRunTime.boxToInteger((int)p.getNumIdle()));
                            p.close();
                            return;
                        }
                        p.setMaxTotal(p.getNumActive());
                        try {
                            Thread.sleep(p.getMaxWaitMillis());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception exception) {
                    this.$outer.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().warn(">>>> Exception closing pool", (Throwable)exception);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).start();
    }

    public ConnectionPooledDBUrl(Map<String, String> dataSource, String driverName, int poolSizePetShard, int socketTimeoutMs) {
        this.dataSource = dataSource;
        this.driverName = driverName;
        this.poolSizePetShard = poolSizePetShard;
        this.socketTimeoutMs = socketTimeoutMs;
        this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG = LoggerFactory.getLogger(ConnectionPooledDBUrl.class);
        this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$driver = (Driver)Class.forName(driverName).newInstance();
        Properties prop = new Properties();
        prop.put("socket_timeout", ((Object)BoxesRunTime.boxToInteger((int)socketTimeoutMs)).toString());
        this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$connectionProperties = prop;
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotalPerKey(poolSizePetShard);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(false);
        this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$$pool = new GenericKeyedObjectPool<String, JdbcConnection>(new PoolableFactory(), config);
    }

    public class PoolableFactory
    implements KeyedPooledObjectFactory<String, JdbcConnection> {
        @Override
        public PooledObject<JdbcConnection> makeObject(String shard) throws SQLException {
            String dbURL = (String)this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().dataSource().apply((Object)shard);
            Connection connection = this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().io$clickhouse$spark$connection$ConnectionPooledDBUrl$$driver().connect(dbURL, this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().io$clickhouse$spark$connection$ConnectionPooledDBUrl$$connectionProperties());
            return new DefaultPooledObject<JdbcConnection>(new JdbcConnection(shard, connection));
        }

        @Override
        public void destroyObject(String key, PooledObject<JdbcConnection> obj) throws SQLException {
            Option dbURL = this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().dataSource().get((Object)key);
            this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().debug("---- Closing connection in pool {}", new Object[]{dbURL});
            obj.getObject().connection().close();
        }

        @Override
        public boolean validateObject(String key, PooledObject<JdbcConnection> obj) {
            block13: {
                boolean bl;
                Option dbURL = this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().dataSource().get((Object)key);
                Connection connection = obj.getObject().connection();
                Statement st = null;
                try {
                    st = connection.createStatement();
                    st.execute("SELECT 1");
                    bl = true;
                }
                catch (SQLException sQLException) {
                    this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().info("Invalidate connection for url: {}", new Object[]{dbURL});
                    break block13;
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer().io$clickhouse$spark$connection$ConnectionPooledDBUrl$$LOG().info("Exception closing statement", (Throwable)sQLException);
                    }
                }
                return bl;
            }
            return false;
        }

        @Override
        public void activateObject(String key, PooledObject<JdbcConnection> object) {
        }

        @Override
        public void passivateObject(String key, PooledObject<JdbcConnection> object) {
        }

        public /* synthetic */ ConnectionPooledDBUrl io$clickhouse$spark$connection$ConnectionPooledDBUrl$PoolableFactory$$$outer() {
            return ConnectionPooledDBUrl.this;
        }

        public PoolableFactory() {
            if (ConnectionPooledDBUrl.this == null) {
                throw null;
            }
        }
    }
}

