#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :3s_tracking_install_total.sh
# @author  :liushuai
# @revision:2017-03-21 14:09
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}


INSTALL_DAILY_3S="${INSTALL_DAILY_3S}/${year}/${month}/${day}/"
INPUT_INSTALL_TOTAL_PATH="$(get_recently_dir "$DM_INSTALL_LIST" "$YESTERDAY" "3s")"
OUT_PATH="${DM_INSTALL_LIST}/${year}/${month}/${day}/3s"

REDUCE_NUM=$(calculate_reduce_num "$INPUT_INSTALL_TOTAL_PATH")

check_await "${INPUT_INSTALL_TOTAL_PATH}/_SUCCESS"

hadoop fs -rm -r ${OUT_PATH}
hadoop jar ../${JAR} mobvista.dmp.datasource.tracking.mapreduce.TrackingInstallTotalMR \
    -Dtask.date=${year}-${month}-${day} \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "${INSTALL_DAILY_3S}" "${INPUT_INSTALL_TOTAL_PATH}" "${OUT_PATH}"

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='3s'" "$OUT_PATH"