#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adserver_interest_tag.sh
# @author: houying
# @date  : 17-5-2
# # # # # # # # # # # # # # # # # # # # # # 

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_INSTALL_PATH="$DM_INSTALL_LIST/$year/$month/$day/adserver"
INPUT_APP_TAG_PATH="$APP_TAG_PATH/$year/$month/$day"
OUTPUT_INTEREST_TAG="$DM_INTEREST_PATH/$year/$month/$day/adserver"

exit 0
check_await "$INPUT_APP_TAG_PATH/_SUCCESS"

REDUCE_NUM=$(calculate_reduce_num "${INPUT_INSTALL_PATH};${INPUT_APP_TAG_PATH}")

hadoop fs -rm -r ${OUTPUT_INTEREST_TAG}

hadoop jar ../${JAR} mobvista.dmp.common.InterestDeviceDistinctMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -Dmapreduce.map.memory.mb=4096 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=4096 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.shuffle.parallelcopies=50
    -Dmapreduce.task.io.sort.factor=100 -Dmapreduce.task.io.sort.mb=512 \
    "$INPUT_APP_TAG_PATH/part-r-00000" "$INPUT_INSTALL_PATH" "$OUTPUT_INTEREST_TAG" "adserver install interest job"

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_interest_tag" "year='$year', month='$month', day='$day', business='adserver'" "$OUTPUT_INTEREST_TAG" || exit 1


echo "[Ad Server + Interest Tag Total End!]"