#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_request_device_total.sh
# @author: walt
# @date  : 16-12-02
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_PATH_TOTAL="$ADN_TOTAL_PATH/${old_year}/${old_month}/${old_day}"
INPUT_PATH_DAILY="$ETL_ADN_ORG_REQ_HOURS/${year}/${month}/${day}"
OUTPUT_PATH="$ADN_TOTAL_PATH/${year}/${month}/${day}"

echo "INPUT_PATH_TOTAL=$INPUT_PATH_TOTAL"
echo "INPUT_PATH_DAILY=$INPUT_PATH_DAILY"
echo "OUTPUT_PATH=$OUTPUT_PATH"

## REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH_TOTAL})

hadoop fs -rm ${OUTPUT_PATH}/*
export HADOOP_CLIENT_OPTS="-Xmx4096m $HADOOP_CLIENT_OPTS"
hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.AdnRequestDeviceTotalMR \
    -Dtask.date=${LOG_TIME} \
    -Dmapreduce.map.memory.mb=4096 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=4096 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dmapreduce.job.reduces=1000 \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "${INPUT_PATH_DAILY}" "${INPUT_PATH_TOTAL}" "${OUTPUT_PATH}" || exit 1


mount_partition "ods_adn_device_total" "year='${year}',month='${month}',day='${day}'"  "$OUTPUT_PATH"

echo "[ADN  device total End!]"
