#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_install_total.sh
# @author: houying
# @date  : 16-11-8
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_ADN_INSTALL_DAILY_PATH="$ETL_ADN_INSTALL_DAILY/$year/$month/$day"
INPUT_ADN_INSTALL_TOTAL_PATH="$DM_INSTALL_LIST/$old_year/$old_month/$old_day/adn_install"
OUTPUT="$DM_INSTALL_LIST/$year/$month/$day/adn_install"

check_await "${INPUT_ADN_INSTALL_TOTAL_PATH}/_SUCCESS"

hadoop fs -rm -r "$OUTPUT"

hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.AdnInstallTotalMR \
    -Dtask.date=${year}-${month}-${day} \
    -Dmapreduce.job.reduces=100 \
    "$INPUT_ADN_INSTALL_DAILY_PATH" "$INPUT_ADN_INSTALL_TOTAL_PATH" "$OUTPUT" || exit 1

mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='adn_install'" "$OUTPUT"

echo "[Adn Install Total End!]"
