#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_request_daily_v2.sh
# @author: wangjf
# @date  : 2020-04-24 19:58:11
# # # # # # # # # # # # # # # # # # # # # #


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
old_path=$(date -d "$ScheduleTime 2 days ago" "+%Y/%m/%d")
date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")

TMP_OUTPUT_PATH="${TMP_AND_REQUEST_SDK_DAILY_PATH}/$date_path"
OUTPUT="$ETL_ADN_REQUEST_SDK_DAILY/$date_path"

# 为bundleId 匹配 packageName
matchBundlePackageV2 "$date_path" "$old_path" "adn_request_sdk" "$TMP_OUTPUT_PATH" "$OUTPUT" "../../${JAR}" "$LOG_TIME"

if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "etl_adn_request_sdk_daily" "dt='$LOG_TIME'" "$OUTPUT" || exit 1

UNMATCH_DATA_PATH="${DEV_UNMATCH_DATA_PATH}/${date_path}/adn_request_sdk"

mount_partition "etl_adn_request_sdk_unmatch" "dt='$LOG_TIME'" "$UNMATCH_DATA_PATH" || exit 1

expire_date=$(date -d "$ScheduleTime 4 days ago" "+%Y%m%d")

expire_date_path=$(date -d "$ScheduleTime 4 days ago" "+%Y/%m/%d")

EXPIRE_OUTPUT_PATH="${DEV_UNMATCH_DATA_PATH}/${expire_date_path}/adn_request_sdk"

# 删除过期的分区及删除对应路径
unmount_partition "etl_adn_request_sdk_unmatch" "dt='${expire_date}'" "${EXPIRE_OUTPUT_PATH}"

echo "[EtlAdnRequestSdkDaily End!]"