#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision:2017-09-01
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")


INPUT_PATH="${DM_INSTALL_LIST}/$date_path/adn_sdk_v2"
OUTPUT_PATH="${DM_INSTALL_LIST}_v2/$date_path/adn_sdk_v2"

check_await ${INPUT_PATH}/_SUCCESS

hadoop fs -rm -r ${OUTPUT_PATH}

REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH})


hadoop jar ../${JAR} mobvista.dmp.main.ParseInstallRCFile \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  -Dmapreduce.map.memory.mb=3072 \
  -Dmapreduce.map.java.opts=-Xmx2458m \
  -Dmapreduce.reduce.memory.mb=3072 \
  -Dmapreduce.reduce.java.opts=-Xmx2458m \
  ${INPUT_PATH} ${OUTPUT_PATH} ${REDUCE_NUM}

if [[ $? -ne 0 ]];then
  exit 255
fi

: '
business="adn_sdk"

spark-submit --class mobvista.dmp.datasource.dm.DmInstallListOrc \
     --name "mobvista.dmp.datasource.dm.DmInstallListOrc.${business}" \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.default.parallelism=500 \
     --conf spark.speculation=true \
     --conf spark.speculation.quantile=0.8 \
     --conf spark.speculation.multiplier=1.2 \
     --files ${HIVE_SITE_PATH} \
     --jars /data/hadoop-alternative/hive/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g  --executor-cores 3  --num-executors 80 \
     ../${JAR} \
     -output ${OUTPUT_PATH} -input ${INPUT_PATH} -business ${business}
'
mount_partition "dm_install_list_v2" "dt='$LOG_TIME', business='adn_sdk_v2'" "$OUTPUT_PATH"
if [[ $? -ne 0 ]];then
  exit 255
fi