set  hive.exec.dynamic.partition.mode=nonstrict;
set  hive.exec.dynamic.partition=true;
set mapred.max.split.size=536870912;
set mapred.min.split.size.per.node=536870912;
set mapred.min.split.size.per.rack=536870912;
set mapreduce.map.memory.mb=4000;
set mapreduce.map.java.opts=-Xmx3000m;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.reduce.java.opts=-Xmx2458m;
set hive.jobname.length=100;


insert overwrite table dwh.dm_install_list_v2 partition(dt='${dt_today}',business='TO')
     select t1.imei,'imei' device_type,'android' platform,t2.platform_app_id package_name,'${update_date}' update_date from
     (select imei,app_id
     from uparpu_main.uparpu_device_active  where dt='${update_date}' and os_platform='1' and imei rlike '^([0-9]{15,17})$' and imei not rlike '^([0]{15,17})$' ) t1
     join
     (select uuid,platform_app_id from  uparpu_main.uparpu_app where platform_app_id like 'com%') t2
     on t1.app_id=t2.uuid
     UNION
     select t1.oaid,'oaid' device_type,'android' platform,t2.platform_app_id package_name,'${update_date}' update_date from
     (select oaid,app_id
     from uparpu_main.uparpu_device_active  where dt='${update_date}' and os_platform='1' and oaid!=''  and oaid!='00000000-0000-0000-0000-000000000000') t1
     join
     (select uuid,platform_app_id from  uparpu_main.uparpu_app where platform_app_id like 'com%') t2
     on t1.app_id=t2.uuid ;

insert into table dwh.dm_install_list_v2 partition(dt='${dt_today}',business='TO')
     select t1.gaid,'gaid' device_type,'android' platform,t2.platform_app_id package_name,'${update_date}' update_date from
     (select gaid,app_id
     from uparpu_main.uparpu_device_active  where dt='${update_date}' and os_platform='1' and gaid!=''  and gaid!='00000000-0000-0000-0000-000000000000') t1
     join
     (select uuid,platform_app_id from  uparpu_main.uparpu_app where platform_app_id like 'com%') t2
     on t1.app_id=t2.uuid
     UNION
     select t1.idfa,'idfa' device_type,'ios' platform,t2.app_store_id package_name,'${update_date}' update_date from
     (select idfa,app_raw_id
     from uparpu_main.uparpu_device_active  where dt='${update_date}' and os_platform='2' and idfa!=''  and idfa!='00000000-0000-0000-0000-000000000000') t1
     join
     (select id,app_store_id from  uparpu_main.uparpu_app where app_store_id!='') t2
     on t1.app_raw_id=t2.id ;

insert into table dwh.dm_install_list_v2 partition(dt='${dt_today}',business='TO')
     select device_id, device_type, platform,package_name, update_date
     from  dwh.dm_install_list_v2 where dt='${dt_one_day_ago}' and business='TO';