#!/usr/bin/env bash

source ../dmp_env.sh
source ././../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
DMP_DSP_REQ_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/dsp_req"

yearpath=$(date -d "1 days ago $ScheduleTime" "+%Y")
mothpath=$(date -d "1 days ago $ScheduleTime" "+%m")
daypath=$(date -d "1 days ago $ScheduleTime" "+%d")

check_await "${DMP_DSP_REQ_INSTALL_LIST_OUTPUT_PATH}/_SUCCESS"


HIVE_CMD=$(hive_func)

$HIVE_CMD  -v  -hivevar  dt_today ${dt_today}   -hivevar yearpath ${yearpath} -hivevar  mothpath ${mothpath} -hivevar  daypath  ${daypath}  -f  insert_dealid_into_dmp_dsp_req.sql
