#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : jiangfan
# @date : 2021-05-25 12:06:00
# # # # # # # # # # # # # # # # # # # # # #
#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_one_days=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

INPUT_PATH="${REYUN_RAW_DATA}/${dt_slash_today}"
check_await  "${INPUT_PATH}"

common_mount_partition "reyun" "pkginfo" "ds='${dt_today}'" "${INPUT_PATH}"

OUTPUT_PATH="${REYUN_DAILY_PATH}/${dt_slash_today}"

hadoop fs -rm -r "${OUTPUT_PATH}"

spark-submit --class mobvista.dmp.datasource.reyun.ReyunDaily \
 --conf spark.network.timeout=720s \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --files ${HIVE_SITE_PATH} \
 --master yarn --deploy-mode cluster  --executor-memory 6g --driver-memory 4g  --executor-cores 3  --num-executors 60 \
 ../../${JAR}  \
 -output ${OUTPUT_PATH} -coalesce 400  -dt_today ${dt_today}

if [[ $? -ne 0 ]];then
  exit 255
fi

mount_partition "etl_reyun_daily" "dt='${dt_today}'" "$OUTPUT_PATH"

hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS