#!/bin/sh

source ../../dmp_env.sh

today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
echo ${today}
echo ${yesterday}

INPUT_PATH="${REYUN_DAILY_PATH}/${today}"

OLD_INPUT_PATH="${DM_INSTALL_LIST}/${yesterday}/reyun"
OUTPUT_PATH="${DM_INSTALL_LIST}/${today}/reyun"

check_await "$INPUT_PATH/_SUCCESS"
check_await "$OLD_INPUT_PATH/_SUCCESS"

hadoop fs -rm -r "$OUTPUT_PATH/"

spark-submit --class mobvista.dmp.datasource.reyun.ReyunInstallList \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --master yarn --deploy-mode cluster --name ReyunInstallList --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 30 \
 ../../${JAR} -input ${INPUT_PATH} -oldInput ${OLD_INPUT_PATH} -output ${OUTPUT_PATH} -date ${dt} -parallelism 500 -coalesce 500


if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_install_list" "year='${dt_today:0:4}', month='${dt_today:4:2}', day='${dt_today:6:2}', business='reyun'" "$OUTPUT_PATH"