#!/usr/bin/env bash

source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y-%m-%d")

if [[ ! -d "/home/hadoop/wangjf" ]]; then
  mkdir /home/hadoop/wangjf

  cd /home/hadoop/wangjf/

  hdfs dfs -get s3://mob-emr-test/wangjf/data/pem/dataplatform_cn.pem .

  chmod 600 dataplatform_cn.pem
fi

fors=100

concurrent=10000

device_type="OAID_MD5"

shell=" -cp /root/workspace/DMP-1.0.3-jar-with-dependencies.jar mobvista.dmp.datasource.ali.UCRequest ${fors} ${concurrent} ${LOG_TIME} ${device_type}"

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]]; then
  exit 255
fi

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "/root/workspace/exec_uc.sh ${fors} ${concurrent} ${LOG_TIME} ${device_type} >/root/workspace/exec_uc_oaid.log &"

if [[ $? -ne 0 ]]; then
  exit 255
fi

sleep $((fors * 60))

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]]; then
  exit 255
fi