#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

dt_slash_oneday=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_oneday}/dsp_req/_SUCCESS"


#H_32_IMEI
IMEI_H_32_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imei"
#H_32_HASH_IMEI
IMEIMD5_H_32_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imeimd5"


hadoop fs -rm -r "${IMEI_H_32_GUANGDIANTONG_RES_PATH}"
hadoop fs -rm -r "${IMEIMD5_H_32_GUANGDIANTONG_RES_PATH}"


spark-submit --class mobvista.dmp.datasource.taobao.EtlH32FromDmInstallListV2 \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --files ${HIVE_SITE_PATH} \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 6  --num-executors 60 \
 ../../${JAR}  \
 -h32_imei ${IMEI_H_32_GUANGDIANTONG_RES_PATH} -h32_imeimd5 ${IMEIMD5_H_32_GUANGDIANTONG_RES_PATH}  \
 -dt_oneday_ago ${dt_oneday_ago}



if [ $? -ne 0 ];then
  exit 255
fi
echo "good job~~"
